/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.client.DragonEggModel;
import com.github.kay9.dragonmounts.client.DragonModel;
import com.github.kay9.dragonmounts.client.DragonRenderer;
import com.github.kay9.dragonmounts.client.Keybinds;
import com.github.kay9.dragonmounts.client.MountControlsMessenger;
import com.github.kay9.dragonmounts.dragon.DragonSpawnEgg;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.egg.HatchableEggBlock;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dragonmounts")
public class DragonMountsLegacy {
    public static final String MOD_ID = "dragonmounts";
    public static final Logger LOG = LogManager.getLogger();
    public static final SimpleChannel NETWORK;

    public DragonMountsLegacy() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DMLRegistry.init(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DMLConfig.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DMLConfig.SERVER);
        DragonMountsLegacy.setupEvents();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private static void setupEvents() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(DragonMountsLegacy::attemptVanillaEggReplacement);
        bus.addListener(e -> e.put((EntityType)DMLRegistry.DRAGON.get(), TameableDragon.createAttributes().m_22265_()));
        bus.addListener(BreedRegistry::hookRegistry);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(DragonMountsLegacy::cameraAngles);
            MinecraftForge.EVENT_BUS.addListener(Keybinds::handleKeyPress);
            MinecraftForge.EVENT_BUS.addListener(MountControlsMessenger::tick);
            bus.addListener(DragonMountsLegacy::registerEggModelLoader);
            bus.addListener(DragonMountsLegacy::addToCreativeTab);
            bus.addListener(e -> e.getItemColors().m_92689_(DragonSpawnEgg::getColor, new ItemLike[]{(ItemLike)DMLRegistry.SPAWN_EGG.get()}));
            bus.addListener(DragonMountsLegacy::rendererRegistry);
            bus.addListener(Keybinds::registerKeybinds);
        }
    }

    private static void attemptVanillaEggReplacement(PlayerInteractEvent.RightClickBlock evt) {
        if (HatchableEggBlock.overrideVanillaDragonEgg(evt.getLevel(), evt.getPos(), evt.getEntity())) {
            evt.setCanceled(true);
        }
    }

    private static void addToCreativeTab(BuildCreativeModeTabContentsEvent evt) {
        ResourceKey tab = evt.getTabKey();
        if (tab == CreativeModeTabs.f_256731_) {
            DragonSpawnEgg.populateTab(evt);
        }
        if (tab == CreativeModeTabs.f_256791_) {
            HatchableEggBlock.populateTab(evt);
        }
    }

    private static void registerEggModelLoader(ModelEvent.RegisterGeometryLoaders evt) {
        evt.register("dragon_egg", (IGeometryLoader)DragonEggModel.Loader.INSTANCE);
    }

    private static void rendererRegistry(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer((EntityType)DMLRegistry.DRAGON.get(), DragonRenderer::new);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)DragonRenderer.LAYER_LOCATION, DragonModel::createBodyLayer);
    }

    private static void cameraAngles(ViewportEvent.ComputeCameraAngles evt) {
        if (Minecraft.m_91087_().f_91074_.m_20202_() instanceof TameableDragon) {
            Camera camera = evt.getCamera();
            int distance = 0;
            int vertical = 0;
            switch (Minecraft.m_91087_().f_91066_.m_92176_()) {
                case THIRD_PERSON_FRONT: {
                    distance = 6;
                    break;
                }
                case THIRD_PERSON_BACK: {
                    distance = 6;
                    vertical = 4;
                }
            }
            camera.m_90568_(-camera.m_90566_((double)distance), (double)vertical, 0.0);
        }
    }

    static {
        String PROTOCOL_VERSION = "1.O";
        NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)DragonMountsLegacy.id("network")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

