/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.Pet;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AI.EntityAINearestTarget3D;
import com.github.L_Ender.cataclysm.entity.AI.MobAIFindWater;
import com.github.L_Ender.cataclysm.entity.AI.MobAILeaveWater;
import com.github.L_Ender.cataclysm.entity.AI.SemiAquaticAIRandomSwimming;
import com.github.L_Ender.cataclysm.entity.BossMonsters.The_Leviathan.Abyss_Blast_Entity;
import com.github.L_Ender.cataclysm.entity.BossMonsters.The_Leviathan.Portal_Abyss_Blast_Entity;
import com.github.L_Ender.cataclysm.entity.Pet.AI.PetSimpleAnimationGoal;
import com.github.L_Ender.cataclysm.entity.Pet.AI.TameableAIFollowOwnerWater;
import com.github.L_Ender.cataclysm.entity.Pet.AnimationPet;
import com.github.L_Ender.cataclysm.entity.etc.GroundPathNavigatorWide;
import com.github.L_Ender.cataclysm.entity.etc.ISemiAquatic;
import com.github.L_Ender.cataclysm.entity.etc.SemiAquaticPathNavigator;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.projectile.Mini_Abyss_Blast_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class The_Baby_Leviathan_Entity
extends AnimationPet
implements ISemiAquatic,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(The_Baby_Leviathan_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Animation BABY_LEVIATHAN_BITE = Animation.create((int)14);
    public static final Animation BABY_LEVIATHAN_ABYSS_BLAST = Animation.create((int)157);
    public float sitProgress;
    public float prevSitProgress;
    public float SwimProgress;
    public float prevSwimProgress;
    private int fishFeedings;
    private boolean isLandNavigator;
    private AttackMode mode = AttackMode.CIRCLE;
    private int blast_cooldown = 0;
    public static final int BLAST_HUNTING_COOLDOWN = 100;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;

    public The_Baby_Leviathan_Entity(EntityType type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
        The_Baby_Leviathan_Entity.setConfigattribute((LivingEntity)this, CMConfig.BabyLeviathanHealthMultiplier, CMConfig.BabyLeviathanDamageMultiplier);
        this.m_274367_(1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.LEVIATHAN_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.LEVIATHAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.LEVIATHAN_DEFEAT.get();
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 2.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7640_();
        if (entity instanceof Mini_Abyss_Blast_Entity || entity instanceof Abyss_Blast_Entity || entity instanceof Portal_Abyss_Blast_Entity) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public static AttributeSupplier.Builder babyleviathan() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new TameableAIFollowOwnerWater(this, 1.3, 4.0f, 2.0f, true));
        this.f_21345_.m_25352_(3, (Goal)new BabyLeviathanAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BabyLeviathanBiteAttackGoal(this, BABY_LEVIATHAN_BITE));
        this.f_21345_.m_25352_(0, (Goal)new BabyLeviathanBlastAttackGoal(this, BABY_LEVIATHAN_ABYSS_BLAST));
        this.f_21345_.m_25352_(4, (Goal)new MobAIFindWater((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MobAILeaveWater((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42528_}), false));
        this.f_21345_.m_25352_(7, (Goal)new SemiAquaticAIRandomSwimming((Animal)this, 1.0, 30));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new EntityAINearestTarget3D((Mob)this, LivingEntity.class, 120, false, true, ModEntities.buildPredicateFromTag(ModTag.BABY_LEVIATHAN_TARGET)){

            public boolean m_8036_() {
                return The_Baby_Leviathan_Entity.this.getCommand() != 2 && !The_Baby_Leviathan_Entity.this.isSitting() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigatorWide((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new BabyLeviathanMoveController(this, 3.0f, 1.0f, 10.0f);
            this.f_21344_ = new SemiAquaticPathNavigator((Mob)this, this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.isSitting()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            travelVector = Vec3.f_82478_;
            super.m_7023_(travelVector);
            return;
        }
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null && this.getAnimation() == NO_ANIMATION) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268659_) || super.m_6673_(source);
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean sit) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)sit);
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag platTag = new CompoundTag();
        this.m_7380_(platTag);
        CompoundTag compound = bucket.m_41784_();
        compound.m_128365_("BabyLeviathanData", (Tag)platTag);
    }

    public void m_142278_(CompoundTag p_148832_) {
        if (p_148832_.m_128441_("BabyLeviathanData")) {
            this.m_7378_(p_148832_.m_128469_("BabyLeviathanData"));
        }
    }

    @Nonnull
    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.THE_BABY_LEVIATHAN_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Optional result;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        InteractionResult type = super.m_6071_(player, hand);
        if (!this.m_21824_() && item == Items.f_42528_) {
            this.m_142075_(player, hand, itemstack);
            this.m_146850_(GameEvent.f_157806_);
            ++this.fishFeedings;
            if (this.fishFeedings > 10 && this.m_217043_().m_188503_(6) == 0 || this.fishFeedings > 30) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && itemstack.m_204117_(ItemTags.f_13156_)) {
            if (this.m_21223_() < this.m_21233_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_146850_(GameEvent.f_157806_);
                this.m_5634_(5.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.m_21824_() && (result = Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this)).isPresent()) {
            return (InteractionResult)result.get();
        }
        InteractionResult interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.m_21824_() && this.m_21830_((LivingEntity)player) && !player.m_6144_()) {
            boolean sit;
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.m_5661_((Component)Component.m_237110_((String)("entity.cataclysm.all.command_" + this.getCommand()), (Object[])new Object[]{this.m_7755_()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.m_21839_(true);
                return InteractionResult.SUCCESS;
            }
            this.m_21839_(false);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isSitting() && this.m_21573_().m_26571_()) {
            this.m_21573_().m_26573_();
        }
        boolean swim = this.m_20069_();
        this.prevSwimProgress = this.SwimProgress;
        this.prevSitProgress = this.sitProgress;
        if (this.SwimProgress < 5.0f && swim) {
            this.SwimProgress += 1.0f;
        }
        if (this.SwimProgress > 0.0f && !swim) {
            this.SwimProgress -= 1.0f;
        }
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.m_20069_() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.m_20069_() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.blast_cooldown > 0) {
            --this.blast_cooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.getAnimation() == BABY_LEVIATHAN_BITE) {
            if (this.getAnimationTick() == 7) {
                this.m_5496_((SoundEvent)ModSounds.LEVIATHAN_BITE.get(), 0.5f, 2.0f);
            }
            if (this.getAnimationTick() == 9) {
                this.biteattack(1.5f, 0.5, 0.5, 0.5);
            }
        }
    }

    private void biteattack(float radius, double inflateX, double inflateY, double inflateZ) {
        double renderYaw = (double)(this.f_20885_ + 90.0f) * Math.PI / 180.0;
        double renderPitch = (float)((double)(-this.m_146909_()) * Math.PI / 180.0);
        this.endPosX = this.m_20185_() + (double)radius * Math.cos(renderYaw) * Math.cos(renderPitch);
        this.endPosZ = this.m_20189_() + (double)radius * Math.sin(renderYaw) * Math.cos(renderPitch);
        this.endPosY = this.m_20186_() + (double)radius * Math.sin(renderPitch);
        if (!this.m_9236_().f_46443_) {
            List<LivingEntity> hit = this.raytraceEntities((Level)this.m_9236_(), (double)inflateX, (double)inflateY, (double)inflateZ, (Vec3)new Vec3((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ)).entities;
            for (LivingEntity target : hit) {
                if (this.m_7307_((Entity)target) || target instanceof The_Baby_Leviathan_Entity || target == this) continue;
                target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
            }
        }
    }

    private BiteHitResult raytraceEntities(Level world, double inflateX, double inflateY, double inflateZ, Vec3 from, Vec3 to) {
        BiteHitResult result = new BiteHitResult();
        this.collidePosX = this.endPosX;
        this.collidePosY = this.endPosY;
        this.collidePosZ = this.endPosZ;
        List entities = world.m_45976_(LivingEntity.class, new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82377_(inflateX, inflateY, inflateZ));
        for (LivingEntity entity : entities) {
            float pad = 2.5f;
            AABB aabb = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.m_82371_(from, to);
            if (aabb.m_82390_(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return null;
    }

    @Override
    public boolean shouldEnterWater() {
        return !this.isSitting();
    }

    @Override
    public boolean shouldLeaveWater() {
        return false;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isSitting();
    }

    @Override
    public int getWaterSearchRange() {
        return 32;
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, BABY_LEVIATHAN_ABYSS_BLAST, BABY_LEVIATHAN_BITE};
    }

    private static enum AttackMode {
        CIRCLE,
        MELEE,
        RANGE;

    }

    static class BabyLeviathanAttackGoal
    extends Goal {
        private final The_Baby_Leviathan_Entity mob;
        private LivingEntity target;
        private float circlingTime = 0.0f;
        private float circleDistance = 4.0f;
        private boolean clockwise = false;
        private float MeleeModeTime = 0.0f;
        private static final int MELEE_MODE_TIME = 100;

        public BabyLeviathanAttackGoal(The_Baby_Leviathan_Entity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.target.m_6084_() && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION;
        }

        public boolean m_8045_() {
            this.target = this.mob.m_5448_();
            return this.target != null;
        }

        public void m_8056_() {
            this.mob.mode = AttackMode.CIRCLE;
            this.circlingTime = 0.0f;
            this.MeleeModeTime = 0.0f;
            this.circleDistance = 4 + this.mob.f_19796_.m_188503_(1);
            this.clockwise = this.mob.f_19796_.m_188499_();
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            this.mob.mode = AttackMode.CIRCLE;
            this.circlingTime = 0.0f;
            this.MeleeModeTime = 0.0f;
            this.circleDistance = 4 + this.mob.f_19796_.m_188503_(1);
            this.clockwise = this.mob.f_19796_.m_188499_();
            this.target = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(this.target)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21573_().m_26573_();
            if (this.mob.m_5448_() == null) {
                this.mob.m_21561_(false);
                this.mob.m_21573_().m_26573_();
            }
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                if (this.mob.mode == AttackMode.CIRCLE) {
                    BlockPos circlePos = this.getLeviathanCirclePos(target);
                    if (circlePos != null) {
                        this.mob.m_21573_().m_26519_((double)circlePos.m_123341_() + 0.5, (double)circlePos.m_123342_(), (double)circlePos.m_123343_() + 0.5, 1.0);
                    }
                    this.mob.mode = this.circlingTime >= (float)this.mob.blast_cooldown ? AttackMode.RANGE : AttackMode.MELEE;
                } else if (this.mob.mode == AttackMode.RANGE) {
                    if (this.mob.m_217043_().m_188501_() * 100.0f < 3.0f) {
                        this.mob.setAnimation(BABY_LEVIATHAN_ABYSS_BLAST);
                    }
                } else if (this.mob.mode == AttackMode.MELEE) {
                    this.MeleeModeTime += 1.0f;
                    this.mob.m_21573_().m_5624_((Entity)target, 1.0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
                    if (this.MeleeModeTime >= 100.0f) {
                        this.mob.mode = AttackMode.RANGE;
                    } else if (this.mob.m_20280_((Entity)target) <= 4.0) {
                        this.mob.setAnimation(BABY_LEVIATHAN_BITE);
                    }
                }
            }
        }

        public BlockPos getLeviathanCirclePos(LivingEntity target) {
            float angle = (float)Math.PI / 180 * (this.clockwise ? -this.circlingTime : this.circlingTime);
            double extraX = this.circleDistance * Mth.m_14031_((float)angle);
            double extraZ = this.circleDistance * Mth.m_14089_((float)angle);
            return BlockPos.m_274561_((double)(target.m_20185_() + 0.5 + extraX), (double)(target.m_20186_() + 4.0), (double)(target.m_20189_() + 0.5 + extraZ));
        }
    }

    static class BabyLeviathanBiteAttackGoal
    extends PetSimpleAnimationGoal<The_Baby_Leviathan_Entity> {
        public BabyLeviathanBiteAttackGoal(The_Baby_Leviathan_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public void m_8056_() {
            ((The_Baby_Leviathan_Entity)this.entity).m_21573_().m_26573_();
            LivingEntity target = ((The_Baby_Leviathan_Entity)this.entity).m_5448_();
            if (target != null) {
                ((The_Baby_Leviathan_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
            }
            super.m_8056_();
        }

        public void m_8037_() {
            LivingEntity target = ((The_Baby_Leviathan_Entity)this.entity).m_5448_();
            if (((The_Baby_Leviathan_Entity)this.entity).getAnimationTick() < 9 && target != null) {
                ((The_Baby_Leviathan_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            LivingEntity target = ((The_Baby_Leviathan_Entity)this.entity).m_5448_();
            if (target != null) {
                ((The_Baby_Leviathan_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
        }
    }

    static class BabyLeviathanBlastAttackGoal
    extends PetSimpleAnimationGoal<The_Baby_Leviathan_Entity> {
        public BabyLeviathanBlastAttackGoal(The_Baby_Leviathan_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public void m_8056_() {
            ((The_Baby_Leviathan_Entity)this.entity).m_21573_().m_26573_();
            ((The_Baby_Leviathan_Entity)this.entity).m_9236_().m_6269_((Player)null, (Entity)this.entity, (SoundEvent)ModSounds.ABYSS_BLAST.get(), SoundSource.NEUTRAL, 1.0f, 2.0f);
            LivingEntity target = ((The_Baby_Leviathan_Entity)this.entity).m_5448_();
            if (target != null) {
                ((The_Baby_Leviathan_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
                ((The_Baby_Leviathan_Entity)this.entity).m_21391_((Entity)target, 30.0f, 90.0f);
            }
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
            ((The_Baby_Leviathan_Entity)this.entity).blast_cooldown = 100;
        }

        public void m_8037_() {
            ((The_Baby_Leviathan_Entity)this.entity).m_21573_().m_26573_();
            LivingEntity target = ((The_Baby_Leviathan_Entity)this.entity).m_5448_();
            if (target != null) {
                ((The_Baby_Leviathan_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
                ((The_Baby_Leviathan_Entity)this.entity).m_21391_((Entity)target, 30.0f, 90.0f);
            }
            float dir = 90.0f;
            if (((The_Baby_Leviathan_Entity)this.entity).getAnimationTick() == 37 && !((The_Baby_Leviathan_Entity)this.entity).m_9236_().f_46443_) {
                Mini_Abyss_Blast_Entity DeathBeam = new Mini_Abyss_Blast_Entity((EntityType<? extends Mini_Abyss_Blast_Entity>)((EntityType)ModEntities.MINI_ABYSS_BLAST.get()), ((The_Baby_Leviathan_Entity)this.entity).m_9236_(), (LivingEntity)this.entity, ((The_Baby_Leviathan_Entity)this.entity).m_20185_(), ((The_Baby_Leviathan_Entity)this.entity).m_20186_(), ((The_Baby_Leviathan_Entity)this.entity).m_20189_(), (float)((double)(((The_Baby_Leviathan_Entity)this.entity).f_20885_ + dir) * Math.PI / 180.0), (float)((double)(-((The_Baby_Leviathan_Entity)this.entity).m_146909_()) * Math.PI / 180.0), 80, dir);
                ((The_Baby_Leviathan_Entity)this.entity).m_9236_().m_7967_((Entity)DeathBeam);
            }
        }
    }

    static class BabyLeviathanMoveController
    extends MoveControl {
        private final The_Baby_Leviathan_Entity entity;
        private final float speedMulti;
        private final float ySpeedMod;
        private final float yawLimit;
        private int stillTicks = 0;

        public BabyLeviathanMoveController(The_Baby_Leviathan_Entity entity, float speedMulti, float ySpeedMod, float yawLimit) {
            super((Mob)entity);
            this.entity = entity;
            this.speedMulti = speedMulti;
            this.ySpeedMod = ySpeedMod;
            this.yawLimit = yawLimit;
        }

        public void m_8126_() {
            if (this.entity.m_20069_() && this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.stillTicks = Math.abs(this.entity.f_19854_ - this.entity.m_20185_()) < (double)0.01f && Math.abs(this.entity.f_19855_ - this.entity.m_20186_()) < (double)0.01f && Math.abs(this.entity.f_19856_ - this.entity.m_20189_()) < (double)0.01f ? ++this.stillTicks : 0;
                if (this.stillTicks > 40) {
                    this.entity.m_20256_(this.entity.m_20184_().m_82520_(0.0, -0.005, 0.0));
                }
            }
            if (this.entity.shouldStopMoving()) {
                this.entity.m_7910_(0.0f);
                return;
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.entity.m_21573_().m_26571_()) {
                double lvt_5_1_;
                double lvt_3_1_;
                double lvt_1_1_ = this.f_24975_ - this.entity.m_20185_();
                double lvt_7_1_ = lvt_1_1_ * lvt_1_1_ + (lvt_3_1_ = this.f_24976_ - this.entity.m_20186_()) * lvt_3_1_ + (lvt_5_1_ = this.f_24977_ - this.entity.m_20189_()) * lvt_5_1_;
                if (lvt_7_1_ < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                } else {
                    float lvt_9_1_ = (float)(Mth.m_14136_((double)lvt_5_1_, (double)lvt_1_1_) * 57.2957763671875) - 90.0f;
                    this.entity.m_146922_(this.m_24991_(this.entity.m_146908_(), lvt_9_1_, this.yawLimit));
                    this.entity.f_20883_ = this.entity.m_146908_();
                    this.entity.f_20885_ = this.entity.m_146908_();
                    float lvt_10_1_ = (float)(this.f_24978_ * (double)this.speedMulti * 3.0 * this.entity.m_21133_(Attributes.f_22279_));
                    if (this.entity.m_20069_()) {
                        if (lvt_3_1_ > 0.0 && this.entity.f_19862_) {
                            this.entity.m_20256_(this.entity.m_20184_().m_82520_(0.0, (double)0.08f, 0.0));
                        } else {
                            this.entity.m_20256_(this.entity.m_20184_().m_82520_(0.0, (double)this.entity.m_6113_() * lvt_3_1_ * 0.6 * (double)this.ySpeedMod, 0.0));
                        }
                        this.entity.m_7910_(lvt_10_1_ * 0.02f);
                        float lvt_11_1_ = -((float)(Mth.m_14136_((double)lvt_3_1_, (double)Mth.m_14116_((float)((float)(lvt_1_1_ * lvt_1_1_ + lvt_5_1_ * lvt_5_1_)))) * 57.2957763671875));
                        lvt_11_1_ = Mth.m_14036_((float)Mth.m_14177_((float)lvt_11_1_), (float)-85.0f, (float)85.0f);
                        this.entity.m_146926_(this.m_24991_(this.entity.m_146909_(), lvt_11_1_, 5.0f));
                        float lvt_12_1_ = Mth.m_14089_((float)(this.entity.m_146909_() * ((float)Math.PI / 180)));
                        float lvt_13_1_ = Mth.m_14031_((float)(this.entity.m_146909_() * ((float)Math.PI / 180)));
                        this.entity.f_20902_ = lvt_12_1_ * lvt_10_1_;
                        this.entity.f_20901_ = -lvt_13_1_ * lvt_10_1_;
                    } else {
                        this.entity.m_7910_(lvt_10_1_ * 0.1f);
                    }
                }
            } else {
                this.entity.m_7910_(0.0f);
                this.entity.m_21570_(0.0f);
                this.entity.m_21567_(0.0f);
                this.entity.m_21564_(0.0f);
            }
        }
    }

    public static class BiteHitResult {
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

