/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.rendering.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.v3.rendering.DrawableColor;
import de.keksuccino.fancymenu.v3.rendering.RenderingUtils;
import de.keksuccino.fancymenu.v3.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.v3.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.v3.rendering.ui.widget.slider.ExtendedSliderButton;
import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class UIBase
extends RenderingUtils {
    public static final int ELEMENT_BORDER_THICKNESS = 1;
    public static final int VERTICAL_SCROLL_BAR_WIDTH = 5;
    public static final int VERTICAL_SCROLL_BAR_HEIGHT = 40;
    public static final int HORIZONTAL_SCROLL_BAR_WIDTH = 40;
    public static final int HORIZONTAL_SCROLL_BAR_HEIGHT = 5;
    public static final DrawableColor area_background_color = DrawableColor.of(new Color(43, 43, 43));
    public static final DrawableColor scroll_grabber_color_normal = DrawableColor.of(new Color(89, 91, 93, 100));
    public static final DrawableColor scroll_grabber_color_hover = DrawableColor.of(new Color(102, 104, 104, 100));
    public static final DrawableColor list_entry_color_selected_hovered = DrawableColor.of(new Color(50, 50, 50));
    public static final DrawableColor element_border_color_normal = DrawableColor.of(new Color(93, 97, 100));
    public static final DrawableColor element_border_color_hover = DrawableColor.of(new Color(93, 97, 100));
    public static final DrawableColor element_background_color_normal = DrawableColor.of(new Color(71, 71, 71));
    public static final DrawableColor element_background_color_hover = DrawableColor.of(new Color(83, 156, 212));
    public static final DrawableColor edit_box_background_color = DrawableColor.of(new Color(43, 43, 43));
    public static final DrawableColor edit_box_border_color_normal = DrawableColor.of(new Color(209, 194, 209));
    public static final DrawableColor edit_box_border_color_focused = DrawableColor.of(new Color(227, 211, 227));
    public static final DrawableColor slider_handle_color_normal = DrawableColor.of(new Color(71, 132, 180));
    public static final DrawableColor slider_handle_color_hover = DrawableColor.of(new Color(83, 156, 212));
    public static final DrawableColor edit_box_text_color_normal = DrawableColor.of(new Color(206, 221, 237));
    public static final DrawableColor edit_box_text_color_uneditable = DrawableColor.of(new Color(113, 117, 119));
    public static final DrawableColor edit_box_suggestion_text_color = DrawableColor.of(new Color(-8355712));
    public static final DrawableColor element_label_color_normal = DrawableColor.of(new Color(206, 221, 237));
    public static final DrawableColor element_label_color_inactive = DrawableColor.of(new Color(113, 117, 119));
    public static final DrawableColor screen_background_color = DrawableColor.of(new Color(60, 63, 65));
    public static final DrawableColor screen_background_color_darker = DrawableColor.of(new Color(38, 38, 38));
    public static final DrawableColor generic_text_base_color = DrawableColor.of(new Color(255, 255, 255));

    public static <T> T applyDefaultWidgetSkinTo(T widget) {
        if (widget instanceof ExtendedButton) {
            ExtendedButton e = (ExtendedButton)widget;
            return (T)UIBase.applyDefaultButtonSkinTo(e);
        }
        if (widget instanceof ExtendedEditBox) {
            ExtendedEditBox e = (ExtendedEditBox)widget;
            return (T)UIBase.applyDefaultEditBoxSkinTo(e);
        }
        if (widget instanceof ExtendedSliderButton) {
            ExtendedSliderButton s = (ExtendedSliderButton)widget;
            return (T)UIBase.applyDefaultSliderSkinTo(s);
        }
        return widget;
    }

    private static ExtendedSliderButton applyDefaultSliderSkinTo(ExtendedSliderButton slider) {
        slider.setBackgroundColor(element_background_color_normal);
        slider.setBorderColor(element_border_color_normal);
        slider.setHandleColorNormal(slider_handle_color_normal);
        slider.setHandleColorHover(slider_handle_color_hover);
        slider.setLabelColorNormal(element_label_color_normal);
        slider.setLabelColorInactive(element_label_color_inactive);
        slider.setLabelShadow(false);
        return slider;
    }

    private static ExtendedEditBox applyDefaultEditBoxSkinTo(ExtendedEditBox editBox) {
        editBox.setTextColor(edit_box_text_color_normal);
        editBox.setTextColorUneditable(edit_box_text_color_uneditable);
        editBox.setBackgroundColor(edit_box_background_color);
        editBox.setBorderNormalColor(edit_box_border_color_normal);
        editBox.setBorderFocusedColor(edit_box_border_color_focused);
        editBox.setSuggestionTextColor(edit_box_suggestion_text_color);
        editBox.setTextShadow(false);
        return editBox;
    }

    private static ExtendedButton applyDefaultButtonSkinTo(ExtendedButton button) {
        button.setBackground(ExtendedButton.ColorButtonBackground.create(element_background_color_normal, element_background_color_hover, element_border_color_normal, element_border_color_hover, 1));
        button.setLabelBaseColorNormal(element_label_color_normal);
        button.setLabelBaseColorInactive(element_label_color_inactive);
        button.setLabelShadowEnabled(false);
        button.setForceDefaultTooltipStyle(true);
        return button;
    }

    public static void renderListingDot(GuiGraphics graphics, float x, float y, int color) {
        UIBase.fillF(graphics.m_280168_(), x, y, x + 4.0f, y + 4.0f, color);
    }

    public static void renderListingDot(GuiGraphics graphics, int x, int y, Color color) {
        graphics.m_280509_(x, y, x + 4, y + 4, color.getRGB());
    }

    public static void renderBorder(PoseStack matrix, int xMin, int yMin, int xMax, int yMax, int borderThickness, DrawableColor borderColor, boolean renderTop, boolean renderLeft, boolean renderRight, boolean renderBottom) {
        UIBase.renderBorder(matrix, (float)xMin, (float)yMin, (float)xMax, (float)yMax, (float)borderThickness, borderColor.getColorInt(), renderTop, renderLeft, renderRight, renderBottom);
    }

    public static void renderBorder(PoseStack matrix, int xMin, int yMin, int xMax, int yMax, int borderThickness, Color borderColor, boolean renderTop, boolean renderLeft, boolean renderRight, boolean renderBottom) {
        UIBase.renderBorder(matrix, (float)xMin, (float)yMin, (float)xMax, (float)yMax, (float)borderThickness, borderColor.getRGB(), renderTop, renderLeft, renderRight, renderBottom);
    }

    public static void renderBorder(PoseStack pose, float xMin, float yMin, float xMax, float yMax, float borderThickness, int borderColor, boolean renderTop, boolean renderLeft, boolean renderRight, boolean renderBottom) {
        if (renderTop) {
            RenderingUtils.fillF(pose, xMin, yMin, xMax, yMin + borderThickness, borderColor);
        }
        if (renderLeft) {
            RenderingUtils.fillF(pose, xMin, yMin + borderThickness, xMin + borderThickness, yMax - borderThickness, borderColor);
        }
        if (renderRight) {
            RenderingUtils.fillF(pose, xMax - borderThickness, yMin + borderThickness, xMax, yMax - borderThickness, borderColor);
        }
        if (renderBottom) {
            RenderingUtils.fillF(pose, xMin, yMax - borderThickness, xMax, yMax, borderColor);
        }
    }

    public static int drawElementLabel(GuiGraphics graphics, Font font, Component text, int x, int y) {
        return UIBase.drawElementLabel(graphics, font, text, x, y, element_label_color_normal.getColorInt());
    }

    public static int drawElementLabel(GuiGraphics graphics, Font font, String text, int x, int y) {
        return UIBase.drawElementLabel(graphics, font, (Component)Component.m_237113_((String)text), x, y, element_label_color_normal.getColorInt());
    }

    public static int drawElementLabel(GuiGraphics graphics, Font font, Component text, int x, int y, int baseColor) {
        return graphics.m_280614_(font, text, x, y, baseColor, false);
    }

    public static int drawElementLabel(GuiGraphics graphics, Font font, String text, int x, int y, int baseColor) {
        return UIBase.drawElementLabel(graphics, font, (Component)Component.m_237113_((String)text), x, y, baseColor);
    }

    public static void setShaderColor(DrawableColor color) {
        Color c = color.getColor();
        float a = Math.min(1.0f, Math.max(0.0f, (float)c.getAlpha() / 255.0f));
        UIBase.setShaderColor(color, a);
    }

    public static void setShaderColor(DrawableColor color, float alpha) {
        Color c = color.getColor();
        float r = Math.min(1.0f, Math.max(0.0f, (float)c.getRed() / 255.0f));
        float g = Math.min(1.0f, Math.max(0.0f, (float)c.getGreen() / 255.0f));
        float b = Math.min(1.0f, Math.max(0.0f, (float)c.getBlue() / 255.0f));
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)alpha);
    }
}

