/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ScrollableScreen
extends Screen {
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected ScrollArea scrollArea;
    protected Screen parent;
    protected String f_96539_;

    public ScrollableScreen(Screen parent, String title) {
        super((Component)Component.m_237113_((String)""));
        this.parent = parent;
        this.f_96539_ = title;
        this.scrollArea = new ScrollArea(0, 50, 300, 0);
        this.scrollArea.backgroundColor = ENTRY_BACKGROUND_COLOR;
    }

    protected void m_7856_() {
        this.scrollArea.x = this.f_96543_ / 2 - 150;
        this.scrollArea.height = this.f_96544_ - 100;
    }

    public void m_7379_() {
        if (!PopupHandler.isPopupActive()) {
            Minecraft.m_91087_().m_91152_(this.parent);
        }
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, SCREEN_BACKGROUND_COLOR.getRGB());
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase)) continue;
            ((ScrollAreaEntryBase)e).isOverlayButtonHovered = this.isOverlayButtonHovered();
        }
        this.scrollArea.render(graphics);
        graphics.m_280509_(0, 0, this.f_96543_, 50, HEADER_FOOTER_COLOR.getRGB());
        graphics.m_280137_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, -1);
        graphics.m_280509_(0, this.f_96544_ - 50, this.f_96543_, this.f_96544_, HEADER_FOOTER_COLOR.getRGB());
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase) || !((ScrollAreaEntryBase)e).isOverlayButtonHoveredAndOverlapsArea() || ((ScrollAreaEntryBase)e).description == null) continue;
            ScrollableScreen.renderDescription(graphics, ((ScrollAreaEntryBase)e).description, MouseInput.getMouseX(), MouseInput.getMouseY());
            break;
        }
    }

    protected static void renderDescription(GuiGraphics graphics, List<String> desc, int mouseX, int mouseY) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = Minecraft.m_91087_().f_91062_.m_92895_(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.m_91087_().f_91080_.f_96543_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.m_91087_().f_91080_.f_96544_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((PoseStack)graphics.m_280168_(), (int)600);
            ScrollableScreen.renderDescriptionBackground(graphics, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : desc) {
                graphics.m_280488_(Minecraft.m_91087_().f_91062_, s, mouseX + 5, mouseY + i2, Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost((PoseStack)graphics.m_280168_());
            RenderSystem.disableBlend();
        }
    }

    protected static void renderDescriptionBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x, y, x + width, y + height, new Color(26, 26, 26, 250).getRGB());
    }

    public boolean isOverlayButtonHovered() {
        return false;
    }

    public static class ScrollAreaEntryBase
    extends ScrollAreaEntry {
        protected int entryHeight = 25;
        protected List<String> description = null;
        protected Consumer<EntryRenderCallback> renderBody;
        protected boolean isOverlayButtonHovered = false;

        public ScrollAreaEntryBase(ScrollArea parent, Consumer<EntryRenderCallback> renderBody) {
            super(parent);
            this.renderBody = renderBody;
        }

        public void renderEntry(GuiGraphics graphics) {
            EntryRenderCallback c = new EntryRenderCallback();
            c.entry = this;
            c.graphics = graphics;
            this.renderBody.accept(c);
        }

        public int getHeight() {
            return this.entryHeight;
        }

        public void setHeight(int height) {
            this.entryHeight = height;
        }

        public List<String> getDescription() {
            return this.description;
        }

        public boolean isOverlayButtonHoveredAndOverlapsArea() {
            return this.isOverlayButtonHovered && this.isHoveredOrFocused();
        }

        public void setDescription(List<String> desc) {
            this.description = desc;
        }

        public void setDescription(String[] desc) {
            this.description = Arrays.asList(desc);
        }

        public static class EntryRenderCallback {
            public ScrollAreaEntryBase entry;
            public GuiGraphics graphics;
        }
    }

    public static class SeparatorEntry
    extends ScrollAreaEntryBase {
        public SeparatorEntry(ScrollArea parent, int height, Color color) {
            super(parent, null);
            this.renderBody = render -> render.graphics.m_280509_(render.entry.x, render.entry.y, render.entry.x + render.entry.getWidth(), render.entry.y + render.entry.getHeight(), color.getRGB());
            this.setHeight(height);
        }
    }

    public static class EmptySpaceEntry
    extends ScrollAreaEntryBase {
        public EmptySpaceEntry(ScrollArea parent, int height) {
            super(parent, null);
            this.renderBody = render -> {};
            this.setHeight(height);
        }
    }

    public static class TextEntry
    extends ScrollAreaEntryBase {
        public String text;
        public boolean bold;

        public TextEntry(ScrollArea parent, String text, boolean bold) {
            super(parent, null);
            this.text = text;
            this.bold = bold;
            this.renderBody = render -> {
                if (this.text != null) {
                    Font font = Minecraft.m_91087_().f_91062_;
                    int xCenter = render.entry.x + render.entry.getWidth() / 2;
                    int yCenter = render.entry.y + render.entry.getHeight() / 2;
                    Object s = this.text;
                    if (this.bold) {
                        s = "\u00a7l" + this.text;
                    }
                    GuiGraphics guiGraphics = render.graphics;
                    Objects.requireNonNull(font);
                    guiGraphics.m_280137_(font, (String)s, xCenter, yCenter - 9 / 2, -1);
                }
            };
            this.setHeight(18);
        }
    }

    public static class TextFieldEntry
    extends ScrollAreaEntryBase {
        public AdvancedTextField textField;

        public TextFieldEntry(ScrollArea parent, AdvancedTextField textField) {
            super(parent, null);
            this.textField = textField;
            this.textField.m_94199_(10000);
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                this.textField.f_93623_ = !this.isOverlayButtonHoveredAndOverlapsArea();
                this.textField.m_93674_(200);
                this.textField.setHeight(20);
                this.textField.m_252865_(xCenter - this.textField.m_5711_() / 2);
                this.textField.m_253211_(render.entry.y + 2);
                this.textField.m_88315_(render.graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91297_());
            };
            this.setHeight(24);
        }
    }

    public static class ButtonEntry
    extends ScrollAreaEntryBase {
        public AdvancedButton button;

        public ButtonEntry(ScrollArea parent, AdvancedButton button) {
            super(parent, null);
            this.button = button;
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                UIBase.colorizeButton(this.button);
                this.button.f_93623_ = !this.isOverlayButtonHoveredAndOverlapsArea();
                this.button.m_93674_(200);
                this.button.setHeight(20);
                this.button.m_252865_(xCenter - this.button.m_5711_() / 2);
                this.button.m_253211_(render.entry.y + 2);
                this.button.m_88315_(render.graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91297_());
            };
            this.setHeight(24);
        }
    }
}

