/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.loadingrequirement;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.LoadingRequirement;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.LoadingRequirementRegistry;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementInstance;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRequirementScreen
extends Screen {
    protected Screen parentScreen;
    protected LoadingRequirementContainer parent;
    protected final LoadingRequirementInstance instance;
    protected boolean isEdit;
    protected Consumer<LoadingRequirementInstance> callback;
    protected ScrollArea requirementsListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea requirementDescriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected AdvancedButton requirementModeButton;
    protected AdvancedButton editValueButton;
    protected AdvancedButton doneButton;
    protected AdvancedButton cancelButton;

    public BuildRequirementScreen(@Nullable Screen parentScreen, @NotNull LoadingRequirementContainer parent, @Nullable LoadingRequirementInstance instanceToEdit, @NotNull Consumer<LoadingRequirementInstance> callback) {
        super((Component)(instanceToEdit != null ? Component.m_237113_((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.edit_requirement", (String[])new String[0])) : Component.m_237113_((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.add_requirement", (String[])new String[0]))));
        this.parentScreen = parentScreen;
        this.parent = parent;
        this.instance = instanceToEdit != null ? instanceToEdit : new LoadingRequirementInstance(null, null, LoadingRequirementInstance.RequirementMode.IF, parent);
        this.isEdit = instanceToEdit != null;
        this.callback = callback;
        this.setContentOfRequirementsList(null);
        if (this.instance.requirement != null) {
            this.setContentOfRequirementsList(this.instance.requirement.getCategory());
            for (ScrollAreaEntry e : this.requirementsListScrollArea.getEntries()) {
                if (!(e instanceof RequirementScrollEntry) || ((RequirementScrollEntry)e).requirement != this.instance.requirement) continue;
                e.setFocused(true);
                break;
            }
        }
        this.editValueButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.edit_value", (String[])new String[0]), true, button -> {
            TextEditorScreen s = new TextEditorScreen(button.m_6035_(), this, null, call -> {
                if (call != null) {
                    this.instance.value = call;
                }
            });
            if (this.instance.requirement != null && this.instance.requirement.getValueFormattingRules() != null) {
                s.formattingRules.addAll(this.instance.requirement.getValueFormattingRules());
            }
            s.multilineMode = false;
            if (this.instance.value != null) {
                s.setText(this.instance.value);
            } else if (this.instance.requirement != null) {
                s.setText(this.instance.requirement.getValuePreset());
            }
            Minecraft.m_91087_().m_91152_((Screen)s);
        }){

            public void m_88315_(@NotNull GuiGraphics p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                LoadingRequirement r = BuildRequirementScreen.this.instance.requirement;
                if (r != null && !r.hasValue()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.no_value", (String[])new String[0]), (String)"%n%"));
                } else {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.normal", (String[])new String[0]), (String)"%n%"));
                }
                this.f_93623_ = r != null && r.hasValue();
                super.m_88315_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.editValueButton);
        this.doneButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            this.callback.accept(this.instance);
        }){

            public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                if (BuildRequirementScreen.this.instance.requirement == null) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.finish.desc.no_requirement_selected", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = false;
                } else if (BuildRequirementScreen.this.instance.value == null && BuildRequirementScreen.this.instance.requirement.hasValue()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.finish.desc.no_value_set", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = false;
                } else {
                    this.setDescription(null);
                    this.f_93623_ = true;
                }
                super.m_87963_(graphics, mouseX, mouseY, partialTicks);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.doneButton);
        this.cancelButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.guicomponents.cancel", (String[])new String[0]), true, button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            if (this.isEdit) {
                this.callback.accept(this.instance);
            } else {
                this.callback.accept(null);
            }
        });
        UIBase.applyDefaultButtonSkinTo(this.cancelButton);
        this.requirementModeButton = new AdvancedButton(0, 0, 150, 20, "", true, button -> {
            this.instance.mode = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? LoadingRequirementInstance.RequirementMode.IF_NOT : LoadingRequirementInstance.RequirementMode.IF;
        }){

            public void m_88315_(@NotNull GuiGraphics p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                if (BuildRequirementScreen.this.instance.mode == LoadingRequirementInstance.RequirementMode.IF) {
                    this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.normal", (String[])new String[0]));
                } else {
                    this.setMessage(Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.opposite", (String[])new String[0]));
                }
                super.m_88315_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        this.requirementModeButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.requirementModeButton);
    }

    protected void m_7856_() {
        Minecraft.m_91087_().m_91268_().m_85378_((double)Minecraft.m_91087_().m_91268_().m_85385_(((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()).intValue(), Minecraft.m_91087_().m_91390_()));
        this.f_96544_ = Minecraft.m_91087_().m_91268_().m_85446_();
        this.f_96543_ = Minecraft.m_91087_().m_91268_().m_85445_();
        super.m_7856_();
        this.setDescription(this.instance.requirement);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
        if (this.isEdit) {
            this.callback.accept(this.instance);
        } else {
            this.callback.accept(null);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.SCREEN_BACKGROUND_COLOR.getRGB());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)titleComp, 20, 20, -1, false);
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.available_requirements", (String[])new String[0]), 20, 50, -1, false);
        this.requirementsListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.requirementsListScrollArea.setHeight(this.f_96544_ - 85, true);
        this.requirementsListScrollArea.setX(20, true);
        this.requirementsListScrollArea.setY(65, true);
        this.requirementsListScrollArea.render(graphics, mouseX, mouseY, partial);
        String descLabelString = Locals.localize((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_description", (String[])new String[0]);
        int descLabelWidth = this.f_96547_.m_92895_(descLabelString);
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, descLabelString, this.f_96543_ - 20 - descLabelWidth, 50, -1, false);
        this.requirementDescriptionScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.requirementDescriptionScrollArea.setHeight(Math.max(40, this.f_96544_ / 2 - 50 - 25), true);
        this.requirementDescriptionScrollArea.setX(this.f_96543_ - 20 - this.requirementDescriptionScrollArea.getWidthWithBorder(), true);
        this.requirementDescriptionScrollArea.setY(65, true);
        this.requirementDescriptionScrollArea.render(graphics, mouseX, mouseY, partial);
        this.doneButton.m_252865_(this.f_96543_ - 20 - this.doneButton.m_5711_());
        this.doneButton.m_253211_(this.f_96544_ - 20 - 20);
        this.doneButton.m_88315_(graphics, mouseX, mouseY, partial);
        if (!this.isEdit) {
            this.cancelButton.m_252865_(this.f_96543_ - 20 - this.cancelButton.m_5711_());
            this.cancelButton.m_253211_(this.doneButton.m_252907_() - 5 - 20);
            this.cancelButton.m_88315_(graphics, mouseX, mouseY, partial);
        } else {
            this.cancelButton.f_93623_ = false;
        }
        this.editValueButton.m_252865_(this.f_96543_ - 20 - this.editValueButton.m_5711_());
        this.editValueButton.m_253211_((this.isEdit ? this.doneButton.m_252907_() : this.cancelButton.m_252907_()) - 15 - 20);
        this.editValueButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.requirementModeButton.m_252865_(this.f_96543_ - 20 - this.cancelButton.m_5711_());
        this.requirementModeButton.m_253211_(this.editValueButton.m_252907_() - 5 - 20);
        this.requirementModeButton.m_88315_(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    protected void setDescription(@Nullable LoadingRequirement requirement) {
        this.requirementDescriptionScrollArea.clearEntries();
        if (requirement != null && requirement.getDescription() != null) {
            for (String s : requirement.getDescription()) {
                TextScrollAreaEntry e = new TextScrollAreaEntry(this.requirementDescriptionScrollArea, (Component)Component.m_237113_((String)s), entry -> {});
                e.setFocusable(false);
                e.setBackgroundColorHover(e.getBackgroundColorIdle());
                e.setPlayClickSound(false);
                this.requirementDescriptionScrollArea.addEntry(e);
            }
        }
    }

    protected void setContentOfRequirementsList(@Nullable String category) {
        block4: {
            LinkedHashMap<String, List<LoadingRequirement>> categories;
            block3: {
                TextListScrollAreaEntry e;
                MutableComponent label;
                this.requirementsListScrollArea.clearEntries();
                categories = LoadingRequirementRegistry.getRequirementsOrderedByCategories();
                if (category != null) break block3;
                for (Map.Entry<String, List<LoadingRequirement>> m : categories.entrySet()) {
                    label = Component.m_237113_((String)m.getKey()).m_130948_(Style.f_131099_.m_178520_(UIBase.TEXT_COLOR_GRAY_1.getRGB()));
                    e = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)label, UIBase.LISTING_DOT_RED, entry -> {
                        this.setContentOfRequirementsList((String)m.getKey());
                        this.instance.requirement = null;
                        this.setDescription(null);
                    });
                    e.setFocusable(false);
                    this.requirementsListScrollArea.addEntry(e);
                }
                for (LoadingRequirement r : LoadingRequirementRegistry.getRequirementsWithoutCategory()) {
                    label = Component.m_237113_((String)r.getDisplayName()).m_130948_(Style.f_131099_.m_178520_(UIBase.TEXT_COLOR_GRAY_1.getRGB()));
                    e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.LISTING_DOT_BLUE, entry -> {
                        this.instance.requirement = r;
                        this.setDescription(this.instance.requirement);
                    });
                    ((RequirementScrollEntry)e).requirement = r;
                    this.requirementsListScrollArea.addEntry(e);
                }
                break block4;
            }
            MutableComponent backLabel = Component.m_237113_((String)Locals.localize((String)"fancymenu.editor.loading_requirement.screens.lists.back", (String[])new String[0])).m_130948_(Style.f_131099_.m_178520_(UIBase.TEXT_COLOR_ORANGE_1.getRGB()));
            TextListScrollAreaEntry backEntry = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)backLabel, UIBase.LISTING_DOT_RED, entry -> {
                this.setContentOfRequirementsList(null);
                this.instance.requirement = null;
                this.setDescription(null);
            });
            backEntry.setFocusable(false);
            this.requirementsListScrollArea.addEntry(backEntry);
            List<LoadingRequirement> l = categories.get(category);
            if (l == null) break block4;
            for (LoadingRequirement r : l) {
                MutableComponent label = Component.m_237113_((String)r.getDisplayName()).m_130948_(Style.f_131099_.m_178520_(UIBase.TEXT_COLOR_GRAY_1.getRGB()));
                RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.LISTING_DOT_BLUE, entry -> {
                    this.instance.requirement = r;
                    this.setDescription(this.instance.requirement);
                });
                e.requirement = r;
                this.requirementsListScrollArea.addEntry(e);
            }
        }
    }

    public static class RequirementScrollEntry
    extends TextListScrollAreaEntry {
        public LoadingRequirement requirement;

        public RequirementScrollEntry(ScrollArea parent, @NotNull Component text, @NotNull Color listDotColor, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, text, listDotColor, onClick);
        }
    }
}

