/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.actions;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.actions.BuildActionScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ConfirmationScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageActionsScreen
extends Screen {
    protected Screen parentScreen;
    protected List<ActionInstance> instances;
    protected ScrollArea actionsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected Consumer<List<ActionInstance>> callback;
    protected AdvancedButton addActionButton;
    protected AdvancedButton moveUpButton;
    protected AdvancedButton moveDownButton;
    protected AdvancedButton editButton;
    protected AdvancedButton removeButton;
    protected AdvancedButton doneButton;

    public ManageActionsScreen(@Nullable Screen parentScreen, @NotNull List<ActionInstance> instances, @NotNull Consumer<List<ActionInstance>> callback) {
        super((Component)Component.m_237113_((String)Locals.localize((String)"fancymenu.editor.action.screens.manage_screen.manage", (String[])new String[0])));
        this.parentScreen = parentScreen;
        this.callback = callback;
        this.instances = instances;
        this.updateActionInstanceScrollArea(false);
        this.addActionButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.add_action", (String[])new String[0]), true, button -> {
            BuildActionScreen s = new BuildActionScreen(this, null, call -> {
                if (call != null) {
                    this.instances.add((ActionInstance)call);
                    this.updateActionInstanceScrollArea(false);
                }
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        });
        this.addActionButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.add_action.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.addActionButton);
        this.moveUpButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.move_action_up", (String[])new String[0]), true, button -> {
            ActionInstance selected;
            int index;
            if (this.isInstanceSelected() && (index = this.instances.indexOf(selected = this.getSelectedInstance())) > 0) {
                this.instances.remove(selected);
                this.instances.add(index - 1, selected);
                this.updateActionInstanceScrollArea(true);
                for (ScrollAreaEntry e : this.actionsScrollArea.getEntries()) {
                    if (!(e instanceof ActionInstanceEntry) || ((ActionInstanceEntry)e).instance != selected) continue;
                    e.setFocused(true);
                    break;
                }
            }
        }){

            public void m_88315_(GuiGraphics p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isInstanceSelected()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.finish.no_action_selected", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = false;
                } else {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.move_action_up.desc", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = true;
                }
                super.m_88315_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.moveUpButton);
        this.moveDownButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.move_action_down", (String[])new String[0]), true, button -> {
            ActionInstance selected;
            int index;
            if (this.isInstanceSelected() && (index = this.instances.indexOf(selected = this.getSelectedInstance())) >= 0 && index <= this.instances.size() - 2) {
                this.instances.remove(selected);
                this.instances.add(index + 1, selected);
                this.updateActionInstanceScrollArea(true);
                for (ScrollAreaEntry e : this.actionsScrollArea.getEntries()) {
                    if (!(e instanceof ActionInstanceEntry) || ((ActionInstanceEntry)e).instance != selected) continue;
                    e.setFocused(true);
                    break;
                }
            }
        }){

            public void m_88315_(GuiGraphics p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isInstanceSelected()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.finish.no_action_selected", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = false;
                } else {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.move_action_down.desc", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = true;
                }
                super.m_88315_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.moveDownButton);
        this.editButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.edit_action", (String[])new String[0]), true, button -> {
            if (this.isInstanceSelected()) {
                BuildActionScreen s = new BuildActionScreen(this, this.getSelectedInstance(), call -> this.updateActionInstanceScrollArea(false));
                Minecraft.m_91087_().m_91152_((Screen)s);
            }
        }){

            public void m_88315_(GuiGraphics p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isInstanceSelected()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.finish.no_action_selected", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = false;
                } else {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.edit_action.desc", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = true;
                }
                super.m_88315_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.editButton);
        this.removeButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.editor.action.screens.remove_action", (String[])new String[0]), true, button -> {
            if (this.isInstanceSelected()) {
                ActionInstance i = this.getSelectedInstance();
                ConfirmationScreen s = new ConfirmationScreen(this, call -> {
                    if (call.booleanValue()) {
                        this.instances.remove(i);
                        this.updateActionInstanceScrollArea(false);
                    }
                }, StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.remove_action.confirm", (String[])new String[0]), (String)"%n%"));
                Minecraft.m_91087_().m_91152_((Screen)s);
            }
        }){

            public void m_88315_(GuiGraphics p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isInstanceSelected()) {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.finish.no_action_selected", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = false;
                } else {
                    this.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.editor.action.screens.remove_action.desc", (String[])new String[0]), (String)"%n%"));
                    this.f_93623_ = true;
                }
                super.m_88315_(p_93657_, p_93658_, p_93659_, p_93660_);
            }
        };
        UIBase.applyDefaultButtonSkinTo(this.removeButton);
        this.doneButton = new AdvancedButton(0, 0, 150, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            this.callback.accept(this.instances);
        });
        UIBase.applyDefaultButtonSkinTo(this.doneButton);
    }

    protected void m_7856_() {
        Minecraft.m_91087_().m_91268_().m_85378_((double)Minecraft.m_91087_().m_91268_().m_85385_(((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()).intValue(), Minecraft.m_91087_().m_91390_()));
        this.f_96544_ = Minecraft.m_91087_().m_91268_().m_85446_();
        this.f_96543_ = Minecraft.m_91087_().m_91268_().m_85445_();
        super.m_7856_();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
        this.callback.accept(this.instances);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, UIBase.SCREEN_BACKGROUND_COLOR.getRGB());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.m_280614_(this.f_96547_, (Component)titleComp, 20, 20, -1, false);
        graphics.m_280056_(this.f_96547_, Locals.localize((String)"fancymenu.editor.action.screens.manage_screen.actions", (String[])new String[0]), 20, 50, -1, false);
        this.actionsScrollArea.setWidth(this.f_96543_ - 20 - 150 - 20 - 20, true);
        this.actionsScrollArea.setHeight(this.f_96544_ - 85, true);
        this.actionsScrollArea.setX(20, true);
        this.actionsScrollArea.setY(65, true);
        this.actionsScrollArea.render(graphics, mouseX, mouseY, partial);
        this.doneButton.m_252865_(this.f_96543_ - 20 - this.doneButton.m_5711_());
        this.doneButton.m_253211_(this.f_96544_ - 20 - 20);
        this.doneButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.removeButton.m_252865_(this.f_96543_ - 20 - this.removeButton.m_5711_());
        this.removeButton.m_253211_(this.doneButton.m_252907_() - 15 - 20);
        this.removeButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.editButton.m_252865_(this.f_96543_ - 20 - this.editButton.m_5711_());
        this.editButton.m_253211_(this.removeButton.m_252907_() - 5 - 20);
        this.editButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.moveDownButton.m_252865_(this.f_96543_ - 20 - this.moveDownButton.m_5711_());
        this.moveDownButton.m_253211_(this.editButton.m_252907_() - 5 - 20);
        this.moveDownButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.moveUpButton.m_252865_(this.f_96543_ - 20 - this.moveUpButton.m_5711_());
        this.moveUpButton.m_253211_(this.moveDownButton.m_252907_() - 5 - 20);
        this.moveUpButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.addActionButton.m_252865_(this.f_96543_ - 20 - this.addActionButton.m_5711_());
        this.addActionButton.m_253211_(this.moveUpButton.m_252907_() - 5 - 20);
        this.addActionButton.m_88315_(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    @Nullable
    protected ActionInstance getSelectedInstance() {
        ScrollAreaEntry e = this.actionsScrollArea.getFocusedEntry();
        if (e instanceof ActionInstanceEntry) {
            return ((ActionInstanceEntry)e).instance;
        }
        return null;
    }

    protected boolean isInstanceSelected() {
        return this.getSelectedInstance() != null;
    }

    protected void updateActionInstanceScrollArea(boolean keepScroll) {
        float oldScrollVertical = this.actionsScrollArea.verticalScrollBar.getScroll();
        float oldScrollHorizontal = this.actionsScrollArea.horizontalScrollBar.getScroll();
        this.actionsScrollArea.clearEntries();
        for (ActionInstance i : this.instances) {
            ActionInstanceEntry e = new ActionInstanceEntry(this.actionsScrollArea, i, 14);
            this.actionsScrollArea.addEntry(e);
        }
        if (keepScroll) {
            this.actionsScrollArea.verticalScrollBar.setScroll(oldScrollVertical);
            this.actionsScrollArea.horizontalScrollBar.setScroll(oldScrollHorizontal);
        }
    }

    public static class ActionInstanceEntry
    extends ScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public ActionInstance instance;
        public final int lineHeight;
        public Font font;
        private MutableComponent displayNameComponent;
        private MutableComponent valueComponent;

        public ActionInstanceEntry(ScrollArea parent, ActionInstance instance, int lineHeight) {
            super(parent, 100, 30);
            this.font = Minecraft.m_91087_().f_91062_;
            this.instance = instance;
            this.lineHeight = lineHeight;
            this.displayNameComponent = Component.m_237113_((String)this.instance.action.getAction()).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GRAY_1.getRGB()));
            String valueString = this.instance.value != null && this.instance.action.hasValue() ? this.instance.value : Locals.localize((String)"fancymenu.editor.action.screens.manage_screen.info.value.none", (String[])new String[0]);
            this.valueComponent = Component.m_237113_((String)(Locals.localize((String)"fancymenu.editor.action.screens.manage_screen.info.value", (String[])new String[0]) + " ")).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GRAY_1.getRGB())).m_7220_((Component)Component.m_237113_((String)valueString).m_6270_(Style.f_131099_.m_178520_(TEXT_COLOR_GREY_4.getRGB())));
            this.setWidth(this.calculateWidth());
            this.setHeight(lineHeight * 2 + 6);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.render(graphics, mouseX, mouseY, partial);
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            int centerYLine2 = this.getY() + 3 + this.lineHeight / 2 * 3;
            RenderSystem.enableBlend();
            ActionInstanceEntry.renderListingDot(graphics, this.getX() + 5, centerYLine1 - 2, LISTING_DOT_RED);
            int n = this.getX() + 5 + 4 + 3;
            Objects.requireNonNull(this.font);
            graphics.m_280614_(this.font, (Component)this.displayNameComponent, n, centerYLine1 - 9 / 2, -1, false);
            ActionInstanceEntry.renderListingDot(graphics, this.getX() + 5 + 4 + 3, centerYLine2 - 2, LISTING_DOT_BLUE);
            int n2 = this.getX() + 5 + 4 + 3 + 4 + 3;
            Objects.requireNonNull(this.font);
            graphics.m_280614_(this.font, (Component)this.valueComponent, n2, centerYLine2 - 9 / 2, -1, false);
        }

        private int calculateWidth() {
            int w = 12 + this.font.m_92852_((FormattedText)this.displayNameComponent) + 5;
            int w2 = 19 + this.font.m_92852_((FormattedText)this.valueComponent) + 5;
            if (w2 > w) {
                w = w2;
            }
            return w;
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
        }
    }

    public static class ActionInstance {
        public ButtonActionContainer action;
        public String value;

        public ActionInstance(ButtonActionContainer action, @Nullable String value) {
            this.action = action;
            this.value = value;
        }
    }
}

