/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button.buttonactions.layout;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.konkrete.localization.Locals;
import java.util.List;

public class ToggleLayoutButtonAction
extends ButtonActionContainer {
    public ToggleLayoutButtonAction() {
        super("fancymenu_buttonaction_toggle_layout");
    }

    @Override
    public String getAction() {
        return "toggle_layout";
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(String value) {
        if (value != null) {
            String name;
            List<MenuCustomizationProperties.LayoutProperties> enabled = MenuCustomizationProperties.getAsLayoutProperties(MenuCustomizationProperties.getProperties());
            List<MenuCustomizationProperties.LayoutProperties> disabled = MenuCustomizationProperties.getAsLayoutProperties(MenuCustomizationProperties.getDisabledProperties());
            for (MenuCustomizationProperties.LayoutProperties l : enabled) {
                if (l.path == null || !(name = Files.getNameWithoutExtension((String)l.path)).equals(value)) continue;
                MenuCustomization.disableLayout(l);
                return;
            }
            for (MenuCustomizationProperties.LayoutProperties l : disabled) {
                if (l.path == null || !(name = Files.getNameWithoutExtension((String)l.path)).equals(value)) continue;
                MenuCustomization.enableLayout(l);
                return;
            }
        }
    }

    @Override
    public String getActionDescription() {
        return Locals.localize((String)"fancymenu.helper.buttonaction.toggle_layout.desc", (String[])new String[0]);
    }

    @Override
    public String getValueDescription() {
        return Locals.localize((String)"fancymenu.helper.buttonaction.toggle_layout.value.desc", (String[])new String[0]);
    }

    @Override
    public String getValueExample() {
        return "my_cool_main_menu_layout";
    }
}

