/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.GuiInitCompletedEvent;
import de.keksuccino.fancymenu.events.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.button.identification.ButtonIdentificator;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.mixin.client.IMixinScreen;
import de.keksuccino.konkrete.localization.LocaleUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.VideoSettingsScreen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ButtonCache {
    private static Map<Long, ButtonData> buttons = new HashMap<Long, ButtonData>();
    private static Map<Long, AbstractWidget> replaced = new HashMap<Long, AbstractWidget>();
    private static Screen current = null;
    private static boolean cached = false;
    private static boolean caching = false;
    private static Map<String, AbstractWidget> customButtons = new HashMap<String, AbstractWidget>();

    @SubscribeEvent
    public void updateCache(InitOrResizeScreenEvent.Post e) {
        if (!caching) {
            cached = false;
            current = e.getScreen();
        }
    }

    @SubscribeEvent
    public void onInitCompleted(GuiInitCompletedEvent e) {
        ButtonCache.cache(e.getScreen());
    }

    private static void cache(Screen s) {
        if (!cached) {
            cached = true;
            if (s instanceof LayoutEditorScreen) {
                return;
            }
            if (!MenuCustomization.isMenuCustomizable(s)) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s != null && s instanceof VideoSettingsScreen && FancyMenu.isOptifineLoaded()) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("slimeknights.")) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("net.optifine")) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s == Minecraft.m_91087_().f_91080_) {
                ButtonCache.updateButtons(s);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, ButtonCache.getButtons(), true));
        }
    }

    private static void updateButtons(Screen s) {
        replaced.clear();
        buttons.clear();
        if (!MenuCustomization.isMenuCustomizable(s)) {
            return;
        }
        if (s != null && s instanceof VideoSettingsScreen && FancyMenu.isOptifineLoaded()) {
            return;
        }
        if (s.getClass().getName().startsWith("slimeknights.")) {
            return;
        }
        if (s.getClass().getName().startsWith("net.optifine")) {
            return;
        }
        List<ButtonData> ids = ButtonCache.cacheButtons(s, 1000, 1000);
        List<ButtonData> btns = ButtonCache.cacheButtons(s, Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
        if (btns.size() == ids.size()) {
            int i = 0;
            for (ButtonData id : ids) {
                ButtonData button = btns.get(i);
                if (!buttons.containsKey(id.getId())) {
                    buttons.put(id.getId(), new ButtonData(button.getButton(), id.getId(), LocaleUtils.getKeyForString((String)button.getButton().m_6035_().getString()), s));
                } else if (((Boolean)FancyMenu.getConfig().getOrDefault("showdebugwarnings", (Object)true)).booleanValue()) {
                    System.out.println("");
                    System.out.println("## WARNING [FANCYMENU]: Overlapping buttons found! ##");
                    System.out.println("At: X=" + button.x + " Y=" + button.y);
                    System.out.println("Labels: " + button.label + ", " + ButtonCache.buttons.get((Object)Long.valueOf((long)id.getId())).label);
                    System.out.println("");
                    System.out.println("FancyMenu found overlapping buttons and wasn't able to generate working IDs for them to make them customizable!");
                    System.out.println("Please report this to the mod author of FancyMenu and give informations about what buttons caused it.");
                    System.out.println("#####################################################");
                    System.out.println("");
                }
                ++i;
            }
        }
        ArrayList<String> compIds = new ArrayList<String>();
        for (ButtonData d : buttons.values()) {
            ButtonIdentificator.setCompatibilityIdentifierToData(d);
            if (compIds.contains(d.compatibilityId)) {
                d.compatibilityId = null;
                continue;
            }
            compIds.add(d.compatibilityId);
        }
    }

    public static List<ButtonData> cacheButtons(Screen s, int screenWidth, int screenHeight) {
        caching = true;
        ArrayList<ButtonData> buttonDataList = new ArrayList<ButtonData>();
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            ((IMixinScreen)s).setFontFancyMenu(Minecraft.m_91087_().f_91062_);
            s.m_6574_(Minecraft.m_91087_(), screenWidth, screenHeight);
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            for (Renderable r : s.f_169369_) {
                if (!(r instanceof AbstractWidget)) continue;
                widgets.add((AbstractWidget)r);
            }
            for (AbstractWidget w : widgets) {
                String idRaw = "" + w.f_93620_ + w.f_93621_;
                long id = 0L;
                if (MathUtils.isLong((String)idRaw)) {
                    id = ButtonCache.getAvailableIdFromBaseId(Long.parseLong(idRaw), ids);
                }
                ids.add(id);
                buttonDataList.add(new ButtonData(w, id, LocaleUtils.getKeyForString((String)w.m_6035_().getString()), s));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        caching = false;
        return buttonDataList;
    }

    protected static Long getAvailableIdFromBaseId(long baseId, List<Long> ids) {
        String newId;
        if (ids.contains(baseId) && MathUtils.isLong((String)(newId = baseId + "1"))) {
            return ButtonCache.getAvailableIdFromBaseId(Long.parseLong(newId), ids);
        }
        return baseId;
    }

    public static void cacheFrom(Screen s, int screenWidth, int screenHeight) {
        ButtonCache.updateButtons(s);
    }

    public static String getKeyForButton(AbstractWidget w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().getKey();
        }
        return null;
    }

    public static ButtonData getButtonForId(long id) {
        return buttons.get(id);
    }

    public static ButtonData getButtonForCompatibilityId(String id) {
        for (ButtonData d : buttons.values()) {
            if (d.getCompatibilityId() == null || !d.getCompatibilityId().equals(id)) continue;
            return d;
        }
        return null;
    }

    public static ButtonData getButtonForKey(String key) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().getKey().equalsIgnoreCase(key)) continue;
            return m.getValue();
        }
        return null;
    }

    public static ButtonData getButtonForName(String name) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().label.equals(name)) continue;
            return m.getValue();
        }
        return null;
    }

    public static List<ButtonData> getButtons() {
        ArrayList<ButtonData> b = new ArrayList<ButtonData>();
        b.addAll(buttons.values());
        return b;
    }

    public static boolean isCaching() {
        return caching;
    }

    public static void clearCustomButtonCache() {
        customButtons.clear();
    }

    public static void cacheCustomButton(String id, AbstractWidget w) {
        customButtons.put(id, w);
    }

    public static AbstractWidget getCustomButton(String id) {
        return customButtons.get(id);
    }
}

