/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationData;
import de.keksuccino.fancymenu.menu.animation.AnimationHandlerEvents;
import de.keksuccino.fancymenu.menu.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.menu.animation.exceptions.AnimationNotFoundException;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, AnimationData> ANIMATIONS = new HashMap<String, AnimationData>();
    private static final List<String> EXTERNAL_ANIMATION_NAMES = new ArrayList<String>();
    protected static boolean preloadCompleted = false;
    protected static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            MinecraftForge.EVENT_BUS.register((Object)new AnimationHandlerEvents());
        }
        initialized = true;
    }

    public static void register(@NotNull IAnimationRenderer animation, @NotNull String name, @NotNull AnimationData.Type type) {
        if (!ANIMATIONS.containsKey(name)) {
            ANIMATIONS.put(name, new AnimationData(animation, name, type));
            if (type == AnimationData.Type.EXTERNAL) {
                EXTERNAL_ANIMATION_NAMES.add(name);
            }
        } else {
            LOGGER.error("[FANCYMENU] Failed to register animation! Animation with same name already exists: " + name);
        }
    }

    public static void unregister(@NotNull IAnimationRenderer animation) {
        AnimationData d = null;
        for (AnimationData a : ANIMATIONS.values()) {
            if (a.animation != animation) continue;
            d = a;
            break;
        }
        if (d != null) {
            AnimationHandler.unregister(d.name);
        }
    }

    public static void unregister(@NotNull String name) {
        if (AnimationHandler.animationExists(name)) {
            ANIMATIONS.remove(name);
            EXTERNAL_ANIMATION_NAMES.remove(name);
        }
    }

    public static void discoverAndRegisterExternalAnimations() {
        File f = FancyMenu.getAnimationPath();
        if (!f.exists() || !f.isDirectory()) {
            return;
        }
        preloadCompleted = false;
        AnimationHandler.clearExternalAnimations();
        File[] filesArray = f.listFiles();
        if (filesArray == null) {
            return;
        }
        for (File a : filesArray) {
            File audio2;
            File audio1;
            List mainFrameSecs;
            String resourceNamespace;
            String replayString;
            String loopString;
            PropertiesSection m;
            String name;
            List metas;
            PropertiesSet props;
            File p;
            String mainAudio = null;
            String introAudio = null;
            int fps = 0;
            boolean loop = true;
            boolean replayIntro = false;
            ArrayList<String> frameNamesMain = new ArrayList<String>();
            ArrayList<String> frameNamesIntro = new ArrayList<String>();
            if (!a.isDirectory() || !(p = new File(a.getAbsolutePath().replace("\\", "/") + "/animation.properties")).exists() || (props = PropertiesSerializer.getProperties((String)p.getPath())) == null || (metas = props.getPropertiesOfType("animation-meta")).isEmpty() || (name = (m = (PropertiesSection)metas.get(0)).getEntryValue("name")) == null) continue;
            String fpsString = m.getEntryValue("fps");
            if (fpsString != null && MathUtils.isInteger((String)fpsString)) {
                fps = Integer.parseInt(fpsString);
            }
            if ((loopString = m.getEntryValue("loop")) != null && loopString.equalsIgnoreCase("false")) {
                loop = false;
            }
            if ((replayString = m.getEntryValue("replayintro")) != null && replayString.equalsIgnoreCase("true")) {
                replayIntro = true;
            }
            if ((resourceNamespace = m.getEntryValue("namespace")) == null || (mainFrameSecs = props.getPropertiesOfType("frames-main")).isEmpty()) continue;
            PropertiesSection mainFrames = (PropertiesSection)mainFrameSecs.get(0);
            Map mainFramesMap = mainFrames.getEntries();
            ArrayList<String> mainFrameKeys = new ArrayList<String>();
            for (Map.Entry me : mainFramesMap.entrySet()) {
                String frameNumber;
                if (!((String)me.getKey()).startsWith("frame_") || !MathUtils.isInteger((String)(frameNumber = ((String)me.getKey()).split("_", 2)[1]))) continue;
                mainFrameKeys.add((String)me.getKey());
            }
            mainFrameKeys.sort((o1, o2) -> {
                String n1 = o1.split("_", 2)[1];
                String n2 = o2.split("_", 2)[1];
                int i1 = Integer.parseInt(n1);
                int i2 = Integer.parseInt(n2);
                return Integer.compare(i1, i2);
            });
            for (String s : mainFrameKeys) {
                frameNamesMain.add("frames_main/" + (String)mainFramesMap.get(s));
            }
            List introFrameSecs = props.getPropertiesOfType("frames-intro");
            if (!introFrameSecs.isEmpty()) {
                PropertiesSection introFrames = (PropertiesSection)introFrameSecs.get(0);
                Map introFramesMap = introFrames.getEntries();
                ArrayList<String> introFrameKeys = new ArrayList<String>();
                for (Map.Entry me : introFramesMap.entrySet()) {
                    String frameNumber;
                    if (!((String)me.getKey()).startsWith("frame_") || !MathUtils.isInteger((String)(frameNumber = ((String)me.getKey()).split("_", 2)[1]))) continue;
                    introFrameKeys.add((String)me.getKey());
                }
                introFrameKeys.sort((o1, o2) -> {
                    String n1 = o1.split("_", 2)[1];
                    String n2 = o2.split("_", 2)[1];
                    int i1 = Integer.parseInt(n1);
                    int i2 = Integer.parseInt(n2);
                    return Integer.compare(i1, i2);
                });
                for (String s : introFrameKeys) {
                    frameNamesIntro.add("frames_intro/" + (String)introFramesMap.get(s));
                }
            }
            if ((audio1 = new File(a.getAbsolutePath().replace("\\", "/") + "/audio/mainaudio.wav")).exists()) {
                mainAudio = audio1.getPath();
            }
            if ((audio2 = new File(a.getAbsolutePath().replace("\\", "/") + "/audio/introaudio.wav")).exists()) {
                introAudio = audio2.getPath();
            }
            ResourcePackAnimationRenderer in = null;
            ResourcePackAnimationRenderer an = null;
            if (!frameNamesIntro.isEmpty() && !frameNamesMain.isEmpty()) {
                in = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesIntro, fps, loop, 0, 0, 100, 100);
                an = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesMain, fps, loop, 0, 0, 100, 100);
            } else if (!frameNamesMain.isEmpty()) {
                an = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesMain, fps, loop, 0, 0, 100, 100);
            }
            try {
                AdvancedAnimation ani;
                if (in != null) {
                    ani = new AdvancedAnimation(in, an, introAudio, mainAudio, replayIntro);
                    ani.propertiesPath = a.getPath();
                    AnimationHandler.register(ani, name, AnimationData.Type.EXTERNAL);
                    ani.prepareAnimation();
                    LOGGER.info("[FANCYMENU] Animation found: " + name);
                    continue;
                }
                if (an != null) {
                    ani = new AdvancedAnimation(null, an, introAudio, mainAudio, false);
                    ani.propertiesPath = a.getPath();
                    AnimationHandler.register(ani, name, AnimationData.Type.EXTERNAL);
                    ani.prepareAnimation();
                    LOGGER.info("[FANCYMENU] Animation found:  " + name);
                    continue;
                }
                LOGGER.error("[FANCYMENU] Failed to register animation: " + name);
            }
            catch (AnimationNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public static List<String> getExternalAnimationNames() {
        return new ArrayList<String>(EXTERNAL_ANIMATION_NAMES);
    }

    private static void clearExternalAnimations() {
        for (String s : EXTERNAL_ANIMATION_NAMES) {
            ANIMATIONS.remove(s);
        }
    }

    public static boolean animationExists(@NotNull String name) {
        return ANIMATIONS.containsKey(name);
    }

    @NotNull
    public static List<IAnimationRenderer> getAnimations() {
        ArrayList<IAnimationRenderer> renderers = new ArrayList<IAnimationRenderer>();
        for (Map.Entry<String, AnimationData> m : ANIMATIONS.entrySet()) {
            renderers.add(m.getValue().animation);
        }
        return renderers;
    }

    @Nullable
    public static IAnimationRenderer getAnimation(String name) {
        if (AnimationHandler.animationExists(name)) {
            return AnimationHandler.ANIMATIONS.get((Object)name).animation;
        }
        return null;
    }

    public static void resetAnimations() {
        for (AnimationData d : ANIMATIONS.values()) {
            d.animation.resetAnimation();
        }
    }

    public static void resetAnimationSounds() {
        for (AnimationData d : ANIMATIONS.values()) {
            if (!(d.animation instanceof AdvancedAnimation)) continue;
            ((AdvancedAnimation)d.animation).resetAudio();
        }
    }

    public static void stopAnimationSounds() {
        for (AnimationData d : ANIMATIONS.values()) {
            if (!(d.animation instanceof AdvancedAnimation)) continue;
            ((AdvancedAnimation)d.animation).stopAudio();
        }
    }

    public static void updateAnimationSizes() {
        for (IAnimationRenderer a : AnimationHandler.getAnimations()) {
            IAnimationRenderer intro;
            if (a instanceof ResourcePackAnimationRenderer) {
                ((ResourcePackAnimationRenderer)a).setupAnimationSize();
                continue;
            }
            if (!(a instanceof AdvancedAnimation)) continue;
            IAnimationRenderer main = ((AdvancedAnimation)a).getMainAnimationRenderer();
            if (main instanceof ResourcePackAnimationRenderer) {
                ((ResourcePackAnimationRenderer)main).setupAnimationSize();
            }
            if (!((intro = ((AdvancedAnimation)a).getIntroAnimationRenderer()) instanceof ResourcePackAnimationRenderer)) continue;
            ((ResourcePackAnimationRenderer)intro).setupAnimationSize();
        }
    }

    public static void preloadAnimations(boolean ignoreAlreadyPreloaded) {
        boolean errors = false;
        if (!preloadCompleted || ignoreAlreadyPreloaded) {
            LOGGER.info("[FANCYMENU] Preloading animations! This could cause the loading screen to freeze for a while..");
            try {
                ArrayList<ResourcePackAnimationRenderer> l = new ArrayList<ResourcePackAnimationRenderer>();
                for (IAnimationRenderer iAnimationRenderer : AnimationHandler.getAnimations()) {
                    if (iAnimationRenderer instanceof AdvancedAnimation) {
                        IAnimationRenderer main = ((AdvancedAnimation)iAnimationRenderer).getMainAnimationRenderer();
                        IAnimationRenderer intro = ((AdvancedAnimation)iAnimationRenderer).getIntroAnimationRenderer();
                        if (main instanceof ResourcePackAnimationRenderer) {
                            l.add((ResourcePackAnimationRenderer)main);
                        }
                        if (!(intro instanceof ResourcePackAnimationRenderer)) continue;
                        l.add((ResourcePackAnimationRenderer)intro);
                        continue;
                    }
                    if (!(iAnimationRenderer instanceof ResourcePackAnimationRenderer)) continue;
                    l.add((ResourcePackAnimationRenderer)iAnimationRenderer);
                }
                for (ResourcePackAnimationRenderer resourcePackAnimationRenderer : l) {
                    for (ResourceLocation rl : resourcePackAnimationRenderer.getAnimationFrames()) {
                        TextureManager t = Minecraft.m_91087_().m_91097_();
                        t.m_118506_(rl);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                errors = true;
            }
            if (!errors) {
                LOGGER.info("[FANCYMENU] Finished preloading animations!");
            } else {
                LOGGER.warn("[FANCYMENU] Finished preloading animations with errors! Check your animations!");
            }
            preloadCompleted = true;
        }
    }

    public static boolean preloadingCompleted() {
        return preloadCompleted;
    }

    @Deprecated
    public static boolean isReady() {
        return true;
    }

    @Deprecated
    public static void setReady(boolean b) {
    }
}

