/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.keksuccino.fancymenu.commands.client.CommandUtils;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.command.execute.ExecuteCommandPacketMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class ServerVariableCommand {
    public static volatile Map<String, List<String>> cachedVariableArguments = new HashMap<String, List<String>>();

    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)Commands.m_82127_((String)"fmvariable").then(Commands.m_82129_((String)"action", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions(builder, "get", "set")).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"variable_name", (ArgumentType)StringArgumentType.string()).executes(stack -> ServerVariableCommand.getVariable((CommandSourceStack)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name")))).suggests((context, builder) -> CommandUtils.getStringSuggestions(builder, ServerVariableCommand.getVariableNameSuggestions(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"set_to_value", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            if (StringArgumentType.getString((CommandContext)context, (String)"action").equalsIgnoreCase("set")) {
                return CommandUtils.getStringSuggestions(builder, "<set_to_value>");
            }
            return CommandUtils.getStringSuggestions(builder, new String[0]);
        }).then(Commands.m_82129_((String)"send_chat_feedback", (ArgumentType)BoolArgumentType.bool()).executes(stack -> ServerVariableCommand.setVariable((CommandSourceStack)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name"), StringArgumentType.getString((CommandContext)stack, (String)"set_to_value"), BoolArgumentType.getBool((CommandContext)stack, (String)"send_chat_feedback"))))))));
    }

    private static String[] getVariableNameSuggestions(ServerPlayer sender) {
        List<String> l = cachedVariableArguments.get(sender.m_20148_().toString());
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int getVariable(CommandSourceStack stack, String getOrSet, String variableName) {
        try {
            if (getOrSet.equalsIgnoreCase("get") && variableName != null) {
                ServerPlayer sender = stack.m_81375_();
                ExecuteCommandPacketMessage msg = new ExecuteCommandPacketMessage();
                msg.direction = "client";
                msg.command = "/fmvariable get " + variableName;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), msg);
            }
        }
        catch (Exception e) {
            stack.m_81352_((Component)Component.m_237113_((String)"Error while executing command!"));
            e.printStackTrace();
        }
        return 1;
    }

    private static int setVariable(CommandSourceStack stack, String getOrSet, String variableName, String setToValue, boolean sendFeedback) {
        try {
            if (getOrSet.equalsIgnoreCase("set") && variableName != null && setToValue != null) {
                ServerPlayer sender = stack.m_81375_();
                ExecuteCommandPacketMessage msg = new ExecuteCommandPacketMessage();
                msg.direction = "client";
                msg.command = "/fmvariable set " + variableName + " " + setToValue + " " + sendFeedback;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), msg);
            }
        }
        catch (Exception e) {
            stack.m_81352_((Component)Component.m_237113_((String)"Error while executing command!"));
            e.printStackTrace();
        }
        return 1;
    }
}

