/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.world.genlayer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import tamaized.voidscape.world.VoidscapeLayeredBiomeProvider;
import tamaized.voidscape.world.genlayer.legacy.AreaTransformer0;
import tamaized.voidscape.world.genlayer.legacy.Context;

public class GenLayerRandomWithOneMajorBiomes
implements AreaTransformer0 {
    public static final Codec<GenLayerRandomWithOneMajorBiomes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(VoidscapeLayeredBiomeProvider.conditionalModLoadedBiome()).fieldOf("biomes").stable().forGetter(obj -> obj.biomes), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_).fieldOf("majorBiome").stable().forGetter(obj -> obj.majorBiome), (App)Codec.INT.fieldOf("chance").stable().forGetter(obj -> obj.chance)).apply((Applicative)instance, instance.stable(GenLayerRandomWithOneMajorBiomes::new)));
    private final List<Either<ResourceKey<Biome>, VoidscapeLayeredBiomeProvider.ConditionalBiomeHolder>> biomes;
    private final List<ResourceKey<Biome>> loadedBiomes;
    private final ResourceKey<Biome> majorBiome;
    private final int chance;
    private VoidscapeLayeredBiomeProvider provider;

    GenLayerRandomWithOneMajorBiomes(List<Either<ResourceKey<Biome>, VoidscapeLayeredBiomeProvider.ConditionalBiomeHolder>> biomes, ResourceKey<Biome> majorBiome, int chance) {
        this.biomes = biomes;
        this.loadedBiomes = VoidscapeLayeredBiomeProvider.getConditionalBiomes(biomes);
        this.majorBiome = majorBiome;
        this.chance = chance;
    }

    public GenLayerRandomWithOneMajorBiomes setup(VoidscapeLayeredBiomeProvider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public int applyPixel(Context iNoiseRandom, int x, int y) {
        return !this.loadedBiomes.isEmpty() && iNoiseRandom.nextRandom(this.chance) == 0 ? this.getRandomBiome(iNoiseRandom) : this.provider.getBiomeId(this.majorBiome);
    }

    private int getRandomBiome(Context random) {
        return this.provider.getBiomeId(this.loadedBiomes.get(random.nextRandom(this.loadedBiomes.size())));
    }
}

