/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.mutable.MutableObject;
import tamaized.voidscape.asm.ASMHooks;
import tamaized.voidscape.world.VoidscapeLayeredBiomeProvider;

public class VoidChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<VoidChunkGenerator> codec = RecordCodecBuilder.create(p_236091_0_ -> p_236091_0_.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(ChunkGenerator::m_62218_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::m_224341_)).apply((Applicative)p_236091_0_, p_236091_0_.stable(VoidChunkGenerator::new)));
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Method BeardifierMarker_INSTANCE;
    private static final MethodHandle handle_BeardifierMarker_INSTANCE;
    private static final Object object_BeardifierMarker_INSTANCE;
    private static final Field NoiseChunk_cellWidth;
    private static final MethodHandle handle_setter_NoiseChunk_cellWidth;
    private static final Field NoiseChunk_noiseSizeXZ;
    private static final MethodHandle handle_setter_NoiseChunk_noiseSizeXZ;

    private VoidChunkGenerator(BiomeSource biomeProvider1, Holder<NoiseGeneratorSettings> dimensionSettings) {
        super(biomeProvider1, dimensionSettings);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return codec;
    }

    private void setupNoiseChunk(NoiseChunk noisechunk, int i, int cellWidth, ChunkPos chunkpos, Blender blender) {
        try {
            handle_setter_NoiseChunk_cellWidth.invokeExact(noisechunk, cellWidth);
            noisechunk.f_188721_ = Math.floorDiv(chunkpos.m_45604_(), cellWidth);
            noisechunk.f_188722_ = Math.floorDiv(chunkpos.m_45605_(), cellWidth);
            int noiseSizeXZ = QuartPos.m_175400_((int)(i * cellWidth));
            handle_setter_NoiseChunk_noiseSizeXZ.invokeExact(noisechunk, noiseSizeXZ);
            int firstNoiseX = QuartPos.m_175400_((int)chunkpos.m_45604_());
            int firstNoiseZ = QuartPos.m_175400_((int)chunkpos.m_45605_());
            for (int ii = 0; ii <= noiseSizeXZ; ++ii) {
                int j = firstNoiseX + ii;
                int k = QuartPos.m_175402_((int)j);
                for (int l = 0; l <= noiseSizeXZ; ++l) {
                    int i1 = firstNoiseZ + l;
                    int j1 = QuartPos.m_175402_((int)i1);
                    Blender.BlendingOutput blender$blendingoutput = blender.m_207242_(k, j1);
                    noisechunk.f_209164_.f_209327_[ii][l] = blender$blendingoutput.f_209729_();
                    noisechunk.f_209165_.f_209327_[ii][l] = blender$blendingoutput.f_209730_();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public NoiseChunk m_224256_(ChunkAccess chunkAccess, StructureManager structureManager, Blender blender, RandomState randomState) {
        NoiseSettings noisesettings = ((NoiseGeneratorSettings)this.m_224341_().m_203334_()).f_64439_().m_224530_((LevelHeightAccessor)chunkAccess);
        ChunkPos chunkpos = chunkAccess.m_7697_();
        int cellWidth = noisesettings.m_189213_() >> 1;
        int i = 16 / cellWidth;
        NoiseChunk noisechunk = new NoiseChunk(i, randomState, chunkpos.m_45604_(), chunkpos.m_45605_(), noisesettings, (DensityFunctions.BeardifierOrMarker)Beardifier.m_223937_((StructureManager)structureManager, (ChunkPos)chunkAccess.m_7697_()), (NoiseGeneratorSettings)this.m_224341_().m_203334_(), (Aquifer.FluidPicker)this.f_188607_.get(), blender);
        this.setupNoiseChunk(noisechunk, i, cellWidth, chunkpos, blender);
        return noisechunk;
    }

    protected OptionalInt m_224239_(LevelHeightAccessor levelHeightAccessor, RandomState random, int x, int z, @Nullable MutableObject<NoiseColumn> noiseColumnMutableObject, @Nullable Predicate<BlockState> blockStatePredicate) {
        BlockState[] ablockstate;
        NoiseSettings noisesettings = ((NoiseGeneratorSettings)this.m_224341_().m_203334_()).f_64439_().m_224530_(levelHeightAccessor);
        int i = noisesettings.m_189212_();
        int j = noisesettings.f_158688_();
        int k = Mth.m_14042_((int)j, (int)i);
        int l = Mth.m_14042_((int)noisesettings.f_64508_(), (int)i);
        if (l <= 0) {
            return OptionalInt.empty();
        }
        if (noiseColumnMutableObject == null) {
            ablockstate = null;
        } else {
            ablockstate = new BlockState[noisesettings.f_64508_()];
            noiseColumnMutableObject.setValue((Object)new NoiseColumn(j, ablockstate));
        }
        int i1 = noisesettings.m_189213_() >> 1;
        int j1 = Math.floorDiv(x, i1);
        int k1 = Math.floorDiv(z, i1);
        int l1 = Math.floorMod(x, i1);
        int i2 = Math.floorMod(z, i1);
        int j2 = j1 * i1;
        int k2 = k1 * i1;
        double d0 = (double)l1 / (double)i1;
        double d1 = (double)i2 / (double)i1;
        NoiseChunk noisechunk = new NoiseChunk(1, random, j2, k2, noisesettings, (DensityFunctions.BeardifierOrMarker)object_BeardifierMarker_INSTANCE, (NoiseGeneratorSettings)this.m_224341_().m_203334_(), (Aquifer.FluidPicker)this.f_188607_.get(), Blender.m_190153_());
        this.setupNoiseChunk(noisechunk, 1, i1, new ChunkPos(x, z), Blender.m_190153_());
        noisechunk.m_188791_();
        noisechunk.m_188749_(0);
        for (int l2 = l - 1; l2 >= 0; --l2) {
            noisechunk.m_188810_(l2, 0);
            for (int i3 = i - 1; i3 >= 0; --i3) {
                BlockState blockstate1;
                int j3 = (k + l2) * i + i3;
                double d2 = (double)i3 / (double)i;
                noisechunk.m_209191_(j3, d2);
                noisechunk.m_209230_(x, d0);
                noisechunk.m_209241_(z, d1);
                BlockState blockstate = noisechunk.f_209163_.m_207387_((DensityFunction.FunctionContext)noisechunk);
                BlockState blockState = blockstate1 = blockstate == null ? ((NoiseGeneratorSettings)this.m_224341_().get()).f_64440_() : blockstate;
                if (ablockstate != null) {
                    int k3 = l2 * i + i3;
                    ablockstate[k3] = blockstate1;
                }
                if (blockStatePredicate == null || !blockStatePredicate.test(blockstate1)) continue;
                noisechunk.m_209248_();
                return OptionalInt.of(j3 + 1);
            }
        }
        noisechunk.m_209248_();
        return OptionalInt.empty();
    }

    public void m_213609_(WorldGenLevel worldGenRegion_, ChunkAccess chunk, StructureManager structureManager_) {
        int centerX = chunk.m_7697_().f_45578_;
        int centerZ = chunk.m_7697_().f_45579_;
        int x = centerX * 16;
        int z = centerZ * 16;
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(ASMHooks.seed));
        long seed = rand.m_64690_(worldGenRegion_.m_7328_(), x, z);
        Registry structureRegistry = worldGenRegion_.m_9598_().m_175515_(Registries.f_256944_);
        try {
            Map<Integer, List<Structure>> map = structureRegistry.m_123024_().collect(Collectors.groupingBy(structure -> structure.m_226619_().ordinal()));
            List list = (List)this.f_223020_.get();
            int j = list.size();
            Registry featureRegistry = worldGenRegion_.m_9598_().m_175515_(Registries.f_256988_);
            int k = Math.max(GenerationStep.Decoration.values().length, j);
            for (int l = 0; l < k; ++l) {
                int i1 = 0;
                if (structureManager_.m_220467_()) {
                    for (Structure structurefeature : map.getOrDefault(l, Collections.emptyList())) {
                        rand.m_190064_(seed, i1, l);
                        Supplier<String> supplier = () -> structureRegistry.m_7854_((Object)structurefeature).map(Object::toString).orElseGet(structurefeature::toString);
                        try {
                            worldGenRegion_.m_143497_(supplier);
                            structureManager_.m_220504_(SectionPos.m_123196_((ChunkPos)chunk.m_7697_(), (int)chunk.m_151560_()), structurefeature).forEach(p_196726_ -> p_196726_.m_226850_(worldGenRegion_, structureManager_, (ChunkGenerator)this, (RandomSource)rand, VoidChunkGenerator.writableArea(chunk), chunk.m_7697_()));
                        }
                        catch (Exception exception) {
                            CrashReport crashreport1 = CrashReport.m_127521_((Throwable)exception, (String)"Feature placement");
                            crashreport1.m_127514_("Feature").m_128165_("Description", supplier::get);
                            throw new ReportedException(crashreport1);
                        }
                        ++i1;
                    }
                }
                if (l >= j) continue;
                IntArraySet intset = new IntArraySet();
                for (Holder biome : this.f_62137_.m_207840_()) {
                    List list2 = ((Biome)biome.m_203334_()).m_47536_().m_47818_();
                    if (l >= list2.size()) continue;
                    HolderSet list1 = (HolderSet)list2.get(l);
                    FeatureSorter.StepFeatureData biomesource$stepfeaturedata1 = (FeatureSorter.StepFeatureData)list.get(l);
                    list1.m_203614_().map(Holder::m_203334_).forEach(arg_0 -> VoidChunkGenerator.lambda$applyBiomeDecoration$4((IntSet)intset, biomesource$stepfeaturedata1, arg_0));
                }
                int j1 = intset.size();
                int[] aint = intset.toIntArray();
                Arrays.sort(aint);
                FeatureSorter.StepFeatureData biomesource$stepfeaturedata = (FeatureSorter.StepFeatureData)list.get(l);
                for (int k1 = 0; k1 < j1; ++k1) {
                    int l1 = aint[k1];
                    PlacedFeature placedfeature = (PlacedFeature)biomesource$stepfeaturedata.f_220624_().get(l1);
                    Supplier<String> supplier1 = () -> featureRegistry.m_7854_((Object)placedfeature).map(Object::toString).orElseGet(() -> ((PlacedFeature)placedfeature).toString());
                    rand.m_190064_(seed, l1, l);
                    try {
                        worldGenRegion_.m_143497_(supplier1);
                        for (int y = worldGenRegion_.m_141937_(); y < worldGenRegion_.m_151558_() - 15; y += 15) {
                            Holder biome;
                            BiomeSource biomeSource = this.f_62137_;
                            if (biomeSource instanceof VoidscapeLayeredBiomeProvider) {
                                VoidscapeLayeredBiomeProvider voidscapeLayeredBiomeProvider = (VoidscapeLayeredBiomeProvider)biomeSource;
                                v0 = voidscapeLayeredBiomeProvider.getRealNoiseBiome((centerX << 2) + 2, y, (centerZ << 2) + 2);
                            } else {
                                Climate.Sampler sampler;
                                biomeSource = worldGenRegion_.m_7726_();
                                if (biomeSource instanceof ServerChunkCache) {
                                    ServerChunkCache serverChunkCache = (ServerChunkCache)biomeSource;
                                    sampler = serverChunkCache.m_214994_().m_224579_();
                                } else {
                                    sampler = RandomState.m_255077_((HolderGetter.Provider)worldGenRegion_.m_9598_().m_255325_(), (ResourceKey)this.m_224341_().m_203543_().orElse(ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("voidscape", "void"))), (long)seed).m_224579_();
                                }
                                v0 = biome = this.f_62137_.m_203407_((centerX << 2) + 2, y >> 2, (centerZ << 2) + 2, sampler);
                            }
                            if (!((Biome)biome.m_203334_()).m_47536_().m_186658_(placedfeature)) continue;
                            BlockPos pos = new BlockPos(x, y, z);
                            placedfeature.m_226377_(worldGenRegion_, (ChunkGenerator)this, (RandomSource)rand, pos);
                        }
                        continue;
                    }
                    catch (Exception exception1) {
                        CrashReport crashreport2 = CrashReport.m_127521_((Throwable)exception1, (String)"Feature placement");
                        crashreport2.m_127514_("Feature").m_128165_("Description", supplier1::get);
                        throw new ReportedException(crashreport2);
                    }
                }
            }
        }
        catch (Exception var14) {
            CrashReport lvt_13_1_ = CrashReport.m_127521_((Throwable)var14, (String)"Biome decoration");
            lvt_13_1_.m_127514_("Generation").m_128159_("CenterX", (Object)centerX).m_128159_("CenterZ", (Object)centerZ).m_128159_("Seed", (Object)seed);
            new ReportedException(lvt_13_1_).printStackTrace();
        }
    }

    private static BoundingBox writableArea(ChunkAccess p_187718_) {
        ChunkPos chunkpos = p_187718_.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        LevelHeightAccessor levelheightaccessor = p_187718_.m_183618_();
        int k = levelheightaccessor.m_141937_() + 1;
        int l = levelheightaccessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$4(IntSet intset, FeatureSorter.StepFeatureData biomesource$stepfeaturedata1, PlacedFeature p_196751_) {
        intset.add(biomesource$stepfeaturedata1.f_220625_().applyAsInt(p_196751_));
    }

    static {
        Method tmp_BeardifierMarker_values = null;
        MethodHandle tmp_handle_BeardifierMarker_values = null;
        Object[] tmp_object_BeardifierMarker_values = null;
        Field tmp_NoiseChunk_cellWidth = null;
        MethodHandle tmp_handle_setter_NoiseChunk_cellWidth = null;
        Field tmp_NoiseChunk_noiseSizeXZ = null;
        MethodHandle tmp_handle_setter_NoiseChunk_noiseSizeXZ = null;
        Object tmp_NoiseChunk_FlatCache_values = null;
        Object tmp_handle_getter_NoiseChunk_FlatCache_values = null;
        try {
            tmp_BeardifierMarker_values = ObfuscationReflectionHelper.findMethod(Class.forName("net.minecraft.world.level.levelgen.DensityFunctions$BeardifierMarker"), (String)"values", (Class[])new Class[0]);
            tmp_handle_BeardifierMarker_values = LOOKUP.unreflect(tmp_BeardifierMarker_values);
            tmp_object_BeardifierMarker_values = tmp_handle_BeardifierMarker_values.invoke();
            tmp_NoiseChunk_cellWidth = ObfuscationReflectionHelper.findField(NoiseChunk.class, (String)"f_209170_");
            tmp_handle_setter_NoiseChunk_cellWidth = LOOKUP.unreflectSetter(tmp_NoiseChunk_cellWidth);
            tmp_NoiseChunk_noiseSizeXZ = ObfuscationReflectionHelper.findField(NoiseChunk.class, (String)"f_209169_");
            tmp_handle_setter_NoiseChunk_noiseSizeXZ = LOOKUP.unreflectSetter(tmp_NoiseChunk_noiseSizeXZ);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        BeardifierMarker_INSTANCE = tmp_BeardifierMarker_values;
        handle_BeardifierMarker_INSTANCE = tmp_handle_BeardifierMarker_values;
        object_BeardifierMarker_INSTANCE = ((Object[])Objects.requireNonNull(tmp_object_BeardifierMarker_values))[0];
        NoiseChunk_cellWidth = tmp_NoiseChunk_cellWidth;
        handle_setter_NoiseChunk_cellWidth = tmp_handle_setter_NoiseChunk_cellWidth;
        NoiseChunk_noiseSizeXZ = tmp_NoiseChunk_noiseSizeXZ;
        handle_setter_NoiseChunk_noiseSizeXZ = tmp_handle_setter_NoiseChunk_noiseSizeXZ;
    }
}

