/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.registry;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.client.particle.ParticleSpellCloud;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.regutil.RegistryClass;

@Mod.EventBusSubscriber(modid="voidscape", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModParticles
implements RegistryClass {
    private static final DeferredRegister<ParticleType<?>> REGISTRY = RegUtil.create(ForgeRegistries.PARTICLE_TYPES);
    public static final RegistryObject<ParticleType<ParticleSpellCloudData>> SPELL_CLOUD = REGISTRY.register("spell_cloud", () -> new ParticleType<ParticleSpellCloudData>(false, (ParticleOptions.Deserializer)new ParticleSpellCloudData.Deserializer()){

        public Codec<ParticleSpellCloudData> m_7652_() {
            return ParticleSpellCloudData.codec();
        }
    });

    @Override
    public void init(IEventBus bus) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        ParticleEngine particles = Minecraft.m_91087_().f_91061_;
        particles.m_107378_((ParticleType)SPELL_CLOUD.get(), ParticleSpellCloud.Factory::new);
    }

    public static class ParticleSpellCloudData
    implements ParticleOptions {
        public final int r;
        public final int g;
        public final int b;

        public ParticleSpellCloudData(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        @Nonnull
        public ParticleType<?> m_6012_() {
            return (ParticleType)SPELL_CLOUD.get();
        }

        public static Codec<ParticleSpellCloudData> codec() {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("r").forGetter(obj -> obj.r), (App)Codec.INT.fieldOf("g").forGetter(obj -> obj.g), (App)Codec.INT.fieldOf("b").forGetter(obj -> obj.b)).apply((Applicative)instance, ParticleSpellCloudData::new));
        }

        public void m_7711_(@Nonnull FriendlyByteBuf buf) {
            buf.m_130130_(this.r);
            buf.m_130130_(this.g);
            buf.m_130130_(this.b);
        }

        @Nonnull
        public String m_5942_() {
            return String.format("%d %d %d", this.r, this.g, this.b);
        }

        public static class Deserializer
        implements ParticleOptions.Deserializer<ParticleSpellCloudData> {
            @Nonnull
            public ParticleSpellCloudData fromCommand(@Nonnull ParticleType<ParticleSpellCloudData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
                reader.skipWhitespace();
                int r = reader.readInt();
                reader.skipWhitespace();
                int g = reader.readInt();
                reader.skipWhitespace();
                int b = reader.readInt();
                return new ParticleSpellCloudData(r, g, b);
            }

            @Nonnull
            public ParticleSpellCloudData fromNetwork(@Nonnull ParticleType<ParticleSpellCloudData> type, FriendlyByteBuf buf) {
                return new ParticleSpellCloudData(buf.m_130242_(), buf.m_130242_(), buf.m_130242_());
            }
        }
    }
}

