/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.registry;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.block.EtherealPlantBlock;
import tamaized.voidscape.block.PortalBlock;
import tamaized.voidscape.capability.SubCapability;
import tamaized.voidscape.registry.ModAttributes;
import tamaized.voidscape.registry.ModBlocks;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.regutil.RegistryClass;

public class ModItems
implements RegistryClass {
    public static final DeferredRegister<Item> REGISTRY = RegUtil.create(ForgeRegistries.ITEMS);
    public static final RegistryObject<Item> VOIDIC_CRYSTAL = REGISTRY.register("voidic_crystal", () -> new Item(ItemProps.LAVA_IMMUNE.properties().get()));
    public static final RegistryObject<Item> VOIDIC_TEMPLATE = REGISTRY.register("voidic_template", () -> new Item(ItemProps.LAVA_IMMUNE.properties().get()));
    public static final RegistryObject<Item> ETHEREAL_ESSENCE = REGISTRY.register("ethereal_essence", () -> new Item(ItemProps.LAVA_IMMUNE.properties().get()){

        public InteractionResult m_6225_(UseOnContext context) {
            if (Voidscape.checkForVoidDimension(context.m_43725_()) && context.m_43725_().m_8055_(context.m_8083_()).m_60713_(Blocks.f_50752_)) {
                context.m_43725_().m_46597_(context.m_8083_(), ((Block)ModBlocks.VOIDIC_CRYSTAL_ORE.get()).m_49966_());
                context.m_43722_().m_41774_(1);
                context.m_43725_().m_5594_(null, context.m_8083_(), SoundEvents.f_11739_, SoundSource.BLOCKS, 1.0f, 0.5f + context.m_43725_().m_213780_().m_188501_() * 0.5f);
                if (context.m_43725_() instanceof ServerLevel) {
                    for (int i = 0; i < 50; ++i) {
                        ((ServerLevel)context.m_43725_()).m_8767_((ParticleOptions)ParticleTypes.f_123771_, (double)((float)context.m_8083_().m_123341_() + context.m_43725_().m_213780_().m_188501_()), (double)((float)context.m_8083_().m_123342_() + context.m_43725_().m_213780_().m_188501_()), (double)((float)context.m_8083_().m_123343_() + context.m_43725_().m_213780_().m_188501_()), 0, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return super.m_6225_(context);
        }
    });
    public static final RegistryObject<Item> CHARRED_BONE = REGISTRY.register("charred_bone", () -> new Item(ItemProps.LAVA_IMMUNE.properties().get()){

        public InteractionResult m_6225_(UseOnContext context) {
            BlockPos blockpos;
            BlockPos blockpos1;
            Player player = context.m_43723_();
            Level level = context.m_43725_();
            if (2.canCreatePortal(level.m_8055_(blockpos1 = (blockpos = context.m_8083_()).m_121945_(context.m_43719_())), level, blockpos1)) {
                level.m_5594_(player, blockpos1, SoundEvents.f_12521_, SoundSource.BLOCKS, 1.0f, 0.75f + context.m_43725_().m_213780_().m_188501_() * 0.5f);
                ((PortalBlock)((Object)ModBlocks.PORTAL.get())).tryToCreatePortal(level, blockpos1);
                ItemStack stack = context.m_43722_();
                if (player instanceof ServerPlayer) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }

        public static boolean canCreatePortal(BlockState state, Level level, BlockPos pos) {
            boolean flag = false;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState s = level.m_8055_(pos.m_121945_(direction));
                if (!s.m_60713_((Block)ModBlocks.VOIDIC_CRYSTAL_BLOCK.get()) && !s.m_60713_((Block)ModBlocks.FRAGILE_VOIDIC_CRYSTAL_BLOCK.get()) || ((PortalBlock)((Object)ModBlocks.PORTAL.get())).isPortal((LevelAccessor)level, pos) == null) continue;
                flag = true;
            }
            return state.m_60795_() && flag;
        }
    });
    public static final RegistryObject<Item> CHARRED_WARHAMMER_HEAD = REGISTRY.register("charred_warhammer_head", () -> new Item(ItemProps.LAVA_IMMUNE.properties().get()));
    public static final RegistryObject<Item> TENDRIL = REGISTRY.register("tendril", () -> new Item(ItemProps.LAVA_IMMUNE.properties().get()));
    public static final RegistryObject<Item> FRUIT = REGISTRY.register("fruit", () -> new Item(ItemProps.LAVA_IMMUNE.properties().get().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38765_().m_38767_())){

        public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
            ItemStack itemstack = super.m_5922_(stack, level, entity);
            if (!level.f_46443_) {
                CompoundTag tag = stack.m_41783_();
                tag = tag == null ? null : tag.m_128469_("voidscape");
                EtherealPlantBlock.State state = EtherealPlantBlock.State.VOID;
                if (tag != null) {
                    state = switch (tag.m_128461_("augment")) {
                        default -> EtherealPlantBlock.State.VOID;
                        case "null" -> EtherealPlantBlock.State.NULL;
                        case "overworld" -> EtherealPlantBlock.State.OVERWORLD;
                        case "nether" -> EtherealPlantBlock.State.NETHER;
                        case "end" -> EtherealPlantBlock.State.END;
                    };
                }
                switch (state) {
                    case VOID: {
                        entity.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(data -> data.setInfusion(data.getInfusion() + 150.0f * (2.0f - (float)entity.m_21133_((Attribute)ModAttributes.VOIDIC_INFUSION_RES.get())))));
                        break;
                    }
                    case NULL: {
                        entity.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(data -> data.setInfusion(data.getInfusion() - 150.0f)));
                        break;
                    }
                    case OVERWORLD: {
                        entity.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(data -> data.setParanoia(data.getParanoia() - 150.0f)));
                        break;
                    }
                    case NETHER: {
                        entity.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(data -> data.setParanoia(data.getParanoia() + 150.0f * (2.0f - (float)entity.m_21133_((Attribute)ModAttributes.VOIDIC_PARANOIA_RES.get())))));
                        break;
                    }
                    case END: {
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 3));
                    }
                }
            }
            return itemstack;
        }
    });

    @Override
    public void init(IEventBus bus) {
    }

    public static class ItemProps {
        public static final RegUtil.ItemProps DEFAULT = new RegUtil.ItemProps(Item.Properties::new);
        public static final RegUtil.ItemProps LAVA_IMMUNE = new RegUtil.ItemProps(() -> DEFAULT.properties().get().m_41486_());
    }
}

