/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.registry;

import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.client.entity.model.ModelArmorCorrupt;
import tamaized.voidscape.client.entity.model.ModelCorruptedPawn;
import tamaized.voidscape.client.entity.model.ModelNullServant;
import tamaized.voidscape.client.entity.model.ModelVoidsWrath;
import tamaized.voidscape.client.entity.render.RenderAntiBolt;
import tamaized.voidscape.client.entity.render.RenderCorruptedPawn;
import tamaized.voidscape.client.entity.render.RenderNullServant;
import tamaized.voidscape.client.entity.render.RenderVoidsWrath;
import tamaized.voidscape.entity.AntiBoltEntity;
import tamaized.voidscape.entity.CorruptedPawnEntity;
import tamaized.voidscape.entity.NullServantEntity;
import tamaized.voidscape.entity.VoidsWrathEntity;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.regutil.RegistryClass;

@Mod.EventBusSubscriber(modid="voidscape", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities
implements RegistryClass {
    private static final DeferredRegister<EntityType<?>> REGISTRY = RegUtil.create(ForgeRegistries.ENTITY_TYPES);
    public static final RegistryObject<EntityType<CorruptedPawnEntity>> CORRUPTED_PAWN = REGISTRY.register("corrupted_pawn", () -> ModEntities.build(new ResourceLocation("voidscape", "corrupted_pawn"), ModEntities.makeCastedBuilder(CorruptedPawnEntity.class, CorruptedPawnEntity::new, MobCategory.MONSTER).m_20699_(2.5f, 2.5f).setTrackingRange(256).m_20719_()));
    public static final RegistryObject<EntityType<AntiBoltEntity>> ANTI_BOLT = REGISTRY.register("anti_bolt", () -> ModEntities.make(new ResourceLocation("voidscape", "anti_bolt"), AntiBoltEntity::new, MobCategory.MISC, 0.5f, 0.5f));
    public static final RegistryObject<EntityType<NullServantEntity>> NULL_SERVANT = REGISTRY.register("null_servant", () -> {
        EntityType type = ModEntities.build(new ResourceLocation("voidscape", "null_servant"), ModEntities.makeCastedBuilder(NullServantEntity.class, NullServantEntity::new, MobCategory.MONSTER).m_20699_(0.6f, 1.95f).setTrackingRange(256).m_20719_());
        SpawnPlacements.m_21754_(type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type1, level, spawn, pos, rand) -> NaturalSpawner.canSpawnAtBody((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)pos, (EntityType)type1) && level.m_45933_(null, new AABB(pos).m_82377_(20.0, 3.0, 20.0)).isEmpty());
        return type;
    });
    public static final RegistryObject<EntityType<VoidsWrathEntity>> VOIDS_WRATH = REGISTRY.register("voids_wrath", () -> {
        EntityType type = ModEntities.build(new ResourceLocation("voidscape", "voids_wrath"), ModEntities.makeCastedBuilder(VoidsWrathEntity.class, VoidsWrathEntity::new, MobCategory.MONSTER).m_20699_(0.9f, 2.0f).setTrackingRange(256).m_20719_());
        SpawnPlacements.m_21754_(type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type1, level, spawn, pos, rand) -> rand.m_188503_(3) == 0 && NaturalSpawner.canSpawnAtBody((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)pos, (EntityType)type1) && level.m_45933_(null, new AABB(pos).m_82377_(20.0, 3.0, 20.0)).isEmpty());
        return type;
    });

    @Override
    public void init(IEventBus bus) {
    }

    private static <E extends Entity> EntityType<E> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height) {
        return ModEntities.build(id, ModEntities.makeBuilder(factory, classification).m_20699_(width, height));
    }

    private static <E extends Entity> EntityType<E> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification) {
        return ModEntities.make(id, factory, classification, 0.6f, 1.8f);
    }

    private static <E extends Entity> EntityType<E> build(ResourceLocation id, EntityType.Builder<E> builder) {
        return builder.m_20712_(id.toString());
    }

    private static <E extends Entity> EntityType.Builder<E> makeCastedBuilder(Class<E> cast, EntityType.EntityFactory<E> factory, MobCategory classification) {
        return ModEntities.makeBuilder(factory, classification);
    }

    private static <E extends Entity> EntityType.Builder<E> makeBuilder(EntityType.EntityFactory<E> factory, MobCategory classification) {
        return EntityType.Builder.m_20704_(factory, (MobCategory)classification).m_20699_(0.6f, 1.8f).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CORRUPTED_PAWN.get(), CorruptedPawnEntity.createAttributes().m_22265_());
        event.put((EntityType)VOIDS_WRATH.get(), VoidsWrathEntity.createAttributes().m_22265_());
        event.put((EntityType)NULL_SERVANT.get(), NullServantEntity.createAttributes().m_22265_());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModelLayerLocations.CORRUPTED_PAWN, ModelCorruptedPawn::createMesh);
        event.registerLayerDefinition(ModelLayerLocations.VOIDS_WRATH, () -> ModelVoidsWrath.createMesh(CubeDeformation.f_171458_));
        event.registerLayerDefinition(ModelLayerLocations.VOIDS_WRATH_CHARGED, () -> ModelVoidsWrath.createMesh(new CubeDeformation(1.0f)));
        event.registerLayerDefinition(ModelLayerLocations.NULL_SERVANT, ModelNullServant::createMesh);
        event.registerLayerDefinition(ModelLayerLocations.MODEL_ARMOR_INSANE_OUTER, () -> ModelArmorCorrupt.makeMesh(LayerDefinitions.f_171106_, 0.0f));
        event.registerLayerDefinition(ModelLayerLocations.MODEL_ARMOR_INSANE_INNER, () -> ModelArmorCorrupt.makeMesh(LayerDefinitions.f_171107_, 0.0f));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)CORRUPTED_PAWN.get(), RenderCorruptedPawn::factory);
        event.registerEntityRenderer((EntityType)VOIDS_WRATH.get(), RenderVoidsWrath::new);
        event.registerEntityRenderer((EntityType)NULL_SERVANT.get(), RenderNullServant::new);
        event.registerEntityRenderer((EntityType)ANTI_BOLT.get(), RenderAntiBolt::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModelLayerLocations {
        public static final ModelLayerLocation CORRUPTED_PAWN = ModelLayerLocations.make("corruptedpawn");
        public static final ModelLayerLocation VOIDS_WRATH = ModelLayerLocations.make("voidswrath");
        public static final ModelLayerLocation VOIDS_WRATH_CHARGED = ModelLayerLocations.make("voidswrathcharged");
        public static final ModelLayerLocation NULL_SERVANT = ModelLayerLocations.make("nullservant");
        public static final ModelLayerLocation MODEL_ARMOR_INSANE_OUTER = ModelLayerLocations.make("insane_outer");
        public static final ModelLayerLocation MODEL_ARMOR_INSANE_INNER = ModelLayerLocations.make("insane_inner");

        private static ModelLayerLocation make(String name) {
            return new ModelLayerLocation(new ResourceLocation("voidscape", "main"), name);
        }
    }
}

