/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.registry;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.client.entity.model.ModelArmorCorrupt;
import tamaized.voidscape.registry.ModAttributes;
import tamaized.voidscape.registry.ModEntities;
import tamaized.voidscape.registry.ModItems;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.regutil.RegistryClass;

public class ModArmors
implements RegistryClass {
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_HELMET = RegUtil.ToolAndArmorHelper.helmet(ArmorMaterial.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 1.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.05)));
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_CHEST = RegUtil.ToolAndArmorHelper.chest(ArmorMaterial.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 1.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.05)), (stack, tick) -> ModArmors.elytra(stack));
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_LEGS = RegUtil.ToolAndArmorHelper.legs(ArmorMaterial.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 1.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.05)));
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_BOOTS = RegUtil.ToolAndArmorHelper.boots(ArmorMaterial.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 1.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.05)));
    public static final RegistryObject<Item> CORRUPT_HELMET = RegUtil.ToolAndArmorHelper.helmet(ArmorMaterial.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 2.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.1), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25), RegUtil.AttributeData.make(ModAttributes.VOIDIC_VISIBILITY, AttributeModifier.Operation.MULTIPLY_BASE, 0.15)));
    public static final RegistryObject<Item> CORRUPT_CHEST = RegUtil.ToolAndArmorHelper.chest(ArmorMaterial.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 2.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.1), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), (stack, tick) -> true);
    public static final RegistryObject<Item> CORRUPT_LEGS = RegUtil.ToolAndArmorHelper.legs(ArmorMaterial.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 2.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.1), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)));
    public static final RegistryObject<Item> CORRUPT_BOOTS = RegUtil.ToolAndArmorHelper.boots(ArmorMaterial.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 2.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.1), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)));

    @Override
    public void init(IEventBus bus) {
    }

    public static boolean elytra(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!stack.m_150930_((Item)VOIDIC_CRYSTAL_CHEST.get())) {
            return false;
        }
        CompoundTag nbt = stack.m_41737_("voidscape");
        return nbt != null && nbt.m_128471_("elytra");
    }

    static class ArmorMaterial {
        static final RegUtil.ArmorMaterial VOIDIC_CRYSTAL = new RegUtil.ArmorMaterial("voidic_crystal", 39, new int[]{3, 6, 8, 3}, 17, SoundEvents.f_11673_, 2.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDIC_CRYSTAL.get()}), true, false, false);
        static final RegUtil.ArmorMaterial CORRUPT = new RegUtil.ArmorMaterial("corrupt", 41, new int[]{3, 6, 8, 3}, 19, SoundEvents.f_11679_, 4.0f, 0.15f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TENDRIL.get()}), false, true, true){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public <A extends HumanoidModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, A _default) {
                ModelArmorCorrupt model = new ModelArmorCorrupt(Minecraft.m_91087_().m_167973_().m_171103_(armorSlot == EquipmentSlot.LEGS ? ModEntities.ModelLayerLocations.MODEL_ARMOR_INSANE_INNER : ModEntities.ModelLayerLocations.MODEL_ARMOR_INSANE_OUTER));
                model.rightfoot.f_104207_ = false;
                model.leftfoot.f_104207_ = false;
                model.bodyToLeg.f_104207_ = false;
                model.rightleg.f_104207_ = false;
                model.leftleg.f_104207_ = false;
                model.body.f_104207_ = false;
                model.rightarm.f_104207_ = false;
                model.leftarm.f_104207_ = false;
                model.head.f_104207_ = false;
                model.headoverlay.f_104207_ = false;
                switch (armorSlot) {
                    case FEET: {
                        model.rightfoot.f_104207_ = true;
                        model.leftfoot.f_104207_ = true;
                        break;
                    }
                    case LEGS: {
                        model.rightleg.f_104207_ = true;
                        model.leftleg.f_104207_ = true;
                        break;
                    }
                    case CHEST: {
                        model.bodyToLeg.f_104207_ = true;
                        model.body.f_104207_ = true;
                        model.rightarm.f_104207_ = true;
                        model.leftarm.f_104207_ = true;
                        float tick = (float)entityLiving.f_19797_ + Minecraft.m_91087_().m_91297_();
                        float scale = 0.05f;
                        float amp = 0.15f;
                        float offset = 0.25f;
                        model.topLeftTentacle.f_104203_ = Mth.m_14089_((float)(tick * scale)) * amp + offset;
                        model.topLeftTentacle.f_104204_ = Mth.m_14031_((float)(tick * scale + 0.2f)) * amp + offset;
                        model.topRightTentacle.f_104203_ = Mth.m_14031_((float)(tick * scale + 0.4f)) * amp + offset;
                        model.topRightTentacle.f_104204_ = Mth.m_14089_((float)(tick * scale + 0.6f)) * amp - offset;
                        model.bottomLeftTentacle.f_104203_ = Mth.m_14031_((float)(tick * scale + 0.7f)) * amp - offset;
                        model.bottomLeftTentacle.f_104204_ = Mth.m_14089_((float)(tick * scale + 0.5f)) * amp + offset;
                        model.bottomRightTentacle.f_104203_ = Mth.m_14089_((float)(tick * scale + 0.3f)) * amp - offset;
                        model.bottomRightTentacle.f_104204_ = Mth.m_14031_((float)(tick * scale + 0.1f)) * amp - offset;
                        break;
                    }
                    case HEAD: {
                        model.head.f_104207_ = true;
                        model.headoverlay.f_104207_ = true;
                        break;
                    }
                }
                return (A)((Object)model);
            }

            @Override
            public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, @Nullable String type) {
                return "voidscape".concat(":textures/models/armor/corrupt" + (type == null ? "" : "_overlay") + ".png");
            }
        };

        ArmorMaterial() {
        }
    }
}

