/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.joml.Matrix4f;
import tamaized.voidscape.Config;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.capability.SubCapability;
import tamaized.voidscape.client.DonatorLayer;
import tamaized.voidscape.client.Shaders;
import tamaized.voidscape.client.TintHandler;
import tamaized.voidscape.client.VoidSkyRenderer;
import tamaized.voidscape.client.ui.RenderTurmoil;
import tamaized.voidscape.network.DonatorHandler;
import tamaized.voidscape.network.server.ServerPacketHandlerDonatorSettings;
import tamaized.voidscape.regutil.RegUtil;

public class ClientListener {
    public static void init() {
        IEventBus busMod = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus busForge = MinecraftForge.EVENT_BUS;
        Shaders.init(busMod);
        DonatorLayer.setup();
        TintHandler.setup(busMod);
        busMod.addListener(RenderTurmoil::render);
        busForge.addListener(event -> {
            RenderTurmoil.tick(event);
            if (event.phase == TickEvent.Phase.START) {
                if (Minecraft.m_91087_().f_91073_ == null || Minecraft.m_91087_().f_91074_ == null) {
                    Config.CLIENT_CONFIG.DONATOR.dirty = true;
                } else if (Config.CLIENT_CONFIG.DONATOR.dirty) {
                    Config.CLIENT_CONFIG.DONATOR.dirty = false;
                    if (DonatorHandler.donators.contains(Minecraft.m_91087_().f_91074_.m_20148_())) {
                        Voidscape.NETWORK.sendToServer((Object)new ServerPacketHandlerDonatorSettings(new DonatorHandler.DonatorSettings((Boolean)Config.CLIENT_CONFIG.DONATOR.enabled.get(), (Integer)Config.CLIENT_CONFIG.DONATOR.color.get())));
                    }
                }
                return;
            }
        });
        busForge.addListener(event -> {
            if (Minecraft.m_91087_().f_91073_ != null && Voidscape.checkForVoidDimension((Level)Minecraft.m_91087_().f_91073_)) {
                event.setRed(0.04f);
                event.setGreen(0.03f);
                event.setBlue(0.05f);
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(data -> event.setRed(Mth.m_14036_((float)(data.getParanoia() / 1200.0f), (float)0.04f, (float)1.0f))));
                }
            }
        });
        busForge.addListener(event -> {
            Entity patt3154$temp = event.getCamera().m_90592_();
            if (patt3154$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt3154$temp;
                ItemStack itemstack = living.m_21211_();
                if (living.m_6117_()) {
                    Player player;
                    if (RegUtil.isMyBow(itemstack, Items.f_42411_)) {
                        int i = living.m_21252_();
                        float f1 = (float)i / 20.0f;
                        f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
                        event.setFOV(event.getFOV() * (double)(1.0f - f1 * 0.15f));
                    } else if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && living instanceof Player && (player = (Player)living).m_150108_()) {
                        event.setFOV((double)0.1f);
                    }
                }
            }
        });
        busMod.addListener(event -> event.register(Voidscape.WORLD_KEY_VOID.m_135782_(), new DimensionSpecialEffects(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, false, false){

            public Vec3 m_5927_(Vec3 p_230494_1_, float p_230494_2_) {
                return Vec3.f_82478_;
            }

            public boolean m_5781_(int p_230493_1_, int p_230493_2_) {
                return true;
            }

            @Nullable
            public float[] m_7518_(float p_230492_1_, float p_230492_2_) {
                return null;
            }

            public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
                VoidSkyRenderer.render(ticks, partialTick, poseStack, level, Minecraft.m_91087_());
                return true;
            }
        }));
        busMod.addListener(event -> event.getSkins().forEach(renderer -> {
            LivingEntityRenderer skin = event.getSkin(renderer);
            ClientListener.attachRenderLayers(Objects.requireNonNull(skin));
        }));
    }

    private static <T extends LivingEntity, M extends EntityModel<T>> void attachRenderLayers(LivingEntityRenderer<T, M> renderer) {
        renderer.m_115326_(new DonatorLayer<T, M>(renderer));
    }
}

