/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.capability;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.network.PacketDistributor;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.capability.SubCapability;
import tamaized.voidscape.entity.CorruptedPawnEntity;
import tamaized.voidscape.entity.IEthereal;
import tamaized.voidscape.network.client.ClientPacketNoFlashOnSetHealth;
import tamaized.voidscape.registry.ModAttributes;
import tamaized.voidscape.world.VoidPortalTeleporter;
import tamaized.voidscape.world.VoidTeleporter;

public class Insanity
implements SubCapability.ISubCap.ISubCapData.All {
    private static final ResourceLocation ID = new ResourceLocation("voidscape", "insanity");
    private static final UUID INFUSION_HEALTH_DECAY = UUID.fromString("56ace1bf-6e7f-4724-b4d6-4012519a5b5d");
    private static final UUID INFUSION_ATTACK_DAMAGE = UUID.fromString("08eecf1b-9bbb-46eb-be7e-76308d1241e7");
    private static final UUID INFUSION_RESISTANCE = UUID.fromString("4fe870c1-c74f-4856-b30d-7a4311d72639");
    private static final SoundEvent[] PARANOIA_SOUNDS = new SoundEvent[]{SoundEvents.f_11837_, SoundEvents.f_11899_, SoundEvents.f_11850_, SoundEvents.f_12610_, SoundEvents.f_12611_, SoundEvents.f_12613_, SoundEvents.f_11789_};
    private boolean inPortal;
    private boolean pleaseLeavePortal;
    private boolean teleporting;
    private boolean nextTeleportStep;
    private int teleportTick;
    private float paranoia;
    private float infusion;
    public float decrementInfusion;
    private CorruptedPawnEntity hunt;
    private boolean dirty;

    public void setInPortal(boolean flag) {
        this.inPortal = flag;
    }

    private boolean canTeleport(Entity parent) {
        return parent.m_20186_() <= (double)(parent.m_9236_().m_141937_() + 15) && parent.m_9236_().m_8055_(parent.m_20097_()).m_60713_(Blocks.f_50752_);
    }

    private boolean shouldTeleport(Entity parent) {
        return parent.f_19797_ % 20 == 0 && parent.m_9236_().m_213780_().m_188503_(8) == 0 && this.canTeleport(parent);
    }

    @Override
    public void tick(Entity parent) {
        IEthereal ethereal;
        if (!parent.m_9236_().m_5776_()) {
            if (this.inPortal) {
                this.inPortal = false;
                ++this.teleportTick;
                if (this.teleportTick % 20 == 0) {
                    this.dirty = true;
                }
                this.teleportTick = Mth.m_14045_((int)this.teleportTick, (int)0, (int)200);
                if (!this.pleaseLeavePortal && this.teleportTick >= 200) {
                    if (Voidscape.checkForVoidDimension(parent.m_9236_())) {
                        Voidscape.getLevel(parent.m_9236_(), (ResourceKey<Level>)Level.f_46428_).ifPresent(level -> parent.changeDimension(level, (ITeleporter)VoidPortalTeleporter.INSTANCE));
                    } else {
                        Voidscape.getLevel(parent.m_9236_(), Voidscape.WORLD_KEY_VOID).ifPresent(level -> parent.changeDimension(level, (ITeleporter)VoidPortalTeleporter.INSTANCE));
                    }
                }
            } else {
                this.pleaseLeavePortal = false;
                boolean inVoid = Voidscape.checkForVoidDimension(parent.m_9236_());
                if (inVoid) {
                    int prev = this.teleportTick--;
                    if (this.teleportTick > 0 && this.teleportTick % 20 == 0 || this.teleportTick <= 0 && prev > 0) {
                        this.dirty = true;
                    }
                } else if (this.teleporting) {
                    if (!this.canTeleport(parent)) {
                        this.teleporting = false;
                        this.nextTeleportStep = false;
                    } else if (!this.nextTeleportStep && this.shouldTeleport(parent)) {
                        this.nextTeleportStep = true;
                    }
                    if (this.nextTeleportStep) {
                        ++this.teleportTick;
                        if (this.teleportTick % 20 == 0) {
                            this.nextTeleportStep = false;
                            this.dirty = true;
                        }
                    }
                } else {
                    int prev = this.teleportTick--;
                    if (this.teleportTick > 0 && this.teleportTick % 20 == 0 || this.teleportTick <= 0 && prev > 0) {
                        this.dirty = true;
                    }
                    if (this.shouldTeleport(parent)) {
                        this.teleporting = true;
                        this.nextTeleportStep = true;
                    }
                }
                this.teleportTick = Mth.m_14045_((int)this.teleportTick, (int)0, (int)200);
                if (!inVoid && this.teleportTick >= 200) {
                    Voidscape.getLevel(parent.m_9236_(), Voidscape.WORLD_KEY_VOID).ifPresent(level -> parent.changeDimension(level, (ITeleporter)VoidTeleporter.INSTANCE));
                    return;
                }
            }
        }
        if (parent instanceof IEthereal && (ethereal = (IEthereal)parent).insanityImmunity()) {
            this.paranoia = 0.0f;
            this.infusion = 0.0f;
            return;
        }
        if (Voidscape.checkForVoidDimension(parent.m_9236_()) && !parent.m_5833_()) {
            this.paranoia += this.calcParanoiaRate(parent) / 20.0f;
            this.infusion = this.decrementInfusion <= 0.0f ? (this.infusion += this.calcInfusionRate(parent) / 20.0f) : (this.infusion -= this.decrementInfusion);
        } else {
            this.paranoia = 0.0f;
            this.infusion -= 1.0f;
        }
        this.decrementInfusion = 0.0f;
        this.paranoia = Mth.m_14036_((float)this.paranoia, (float)0.0f, (float)600.0f);
        this.infusion = Mth.m_14036_((float)this.infusion, (float)0.0f, (float)600.0f);
        if (parent instanceof LivingEntity && !parent.m_9236_().m_5776_() && (parent.f_19797_ % 20 * 10 == 0 || this.dirty)) {
            this.refreshEquipmentAttributes((LivingEntity)parent);
            this.sendToClients(parent);
            this.dirty = false;
        }
        if (parent instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)parent;
            this.calculateEffects(living);
        }
    }

    public int getTeleportTick() {
        return this.teleportTick;
    }

    private void calculateEffects(LivingEntity parent) {
        AttributeInstance attribute;
        float perc = this.infusion / 600.0f;
        if (parent.f_19797_ % 20 == 0 && (attribute = parent.m_21051_(Attributes.f_22276_)) != null) {
            attribute.m_22120_(INFUSION_HEALTH_DECAY);
            attribute.m_22120_(INFUSION_ATTACK_DAMAGE);
            attribute.m_22120_(INFUSION_RESISTANCE);
            if (perc > 0.0f) {
                float bound = 1.0f / parent.m_21233_();
                attribute.m_22118_(new AttributeModifier(INFUSION_HEALTH_DECAY, "Voidic Infusion Health Decay", (double)Math.max(1.0f - perc - 1.0f, bound - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
                attribute.m_22118_(new AttributeModifier(INFUSION_ATTACK_DAMAGE, "Voidic Infusion Voidic Attack Damage", (double)(10.0f * perc), AttributeModifier.Operation.ADDITION));
                attribute.m_22118_(new AttributeModifier(INFUSION_RESISTANCE, "Voidic Infusion Voidic Resistance", (double)(10.0f * perc), AttributeModifier.Operation.ADDITION));
                float maxHealth = parent.m_21233_();
                if (parent.m_21223_() > maxHealth) {
                    if (parent instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)parent;
                        Voidscape.NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientPacketNoFlashOnSetHealth());
                    }
                    parent.m_21153_(parent.m_21233_());
                }
            }
            if (perc >= 1.0f && Voidscape.checkForVoidDimension(parent.m_9236_())) {
                parent.m_6469_(parent.m_269291_().m_269341_(), 1024.0f);
            }
        }
        if (parent instanceof Player) {
            float sanity = this.paranoia / 600.0f;
            if (parent.m_9236_().m_5776_() && sanity > 0.25f && parent.f_19797_ % 100 == 0 && parent.m_217043_().m_188501_() <= 0.1f) {
                parent.m_9236_().m_5594_((Player)parent, parent.m_20183_().m_7918_(parent.m_217043_().m_188503_(30) - 30, parent.m_217043_().m_188503_(30) - 30, parent.m_217043_().m_188503_(30) - 30), PARANOIA_SOUNDS[parent.m_217043_().m_188503_(PARANOIA_SOUNDS.length)], SoundSource.MASTER, parent.m_217043_().m_188501_() * 0.9f + 0.1f, parent.m_217043_().m_188501_() * 0.5f + 0.5f);
            }
            if (!parent.m_9236_().m_5776_() && sanity > 0.5f && parent.f_19797_ % 100 == 0 && parent.m_217043_().m_188501_() <= 0.1f) {
                parent.m_6469_(parent.m_269291_().m_269264_(), 1.0f);
            }
            if (parent.m_9236_().m_5776_() && sanity > 0.75f && parent.f_19797_ % 82 == 0) {
                parent.m_9236_().m_5594_((Player)parent, parent.m_20183_(), SoundEvents.f_11768_, SoundSource.MASTER, 4.0f, 1.0f);
            }
            if (!parent.m_9236_().m_5776_()) {
                if (this.hunt == null && this.paranoia >= 600.0f) {
                    this.hunt = new CorruptedPawnEntity(parent.m_9236_()).target((Player)parent);
                    Vec3 vec = new Vec3(0.0, 100.0, 0.0).m_82496_(parent.m_217043_().m_188501_() * 2.0f - 1.0f).m_82524_(parent.m_217043_().m_188501_());
                    this.hunt.m_6034_(parent.m_20185_() + vec.m_7096_(), parent.m_20186_() + vec.m_7098_(), parent.m_20189_() + vec.m_7094_());
                    parent.m_9236_().m_7967_((Entity)this.hunt);
                }
                if (this.hunt != null) {
                    if (this.hunt.m_213877_()) {
                        this.hunt = null;
                    } else if (!this.hunt.m_6084_()) {
                        this.paranoia = 0.0f;
                    } else if (!Voidscape.checkForVoidDimension(parent.m_9236_()) || this.paranoia < 600.0f) {
                        this.hunt.m_142687_(Entity.RemovalReason.DISCARDED);
                        this.hunt = null;
                    } else if (parent.m_20270_((Entity)this.hunt) <= 0.25f) {
                        parent.m_6469_(parent.m_269291_().m_269341_(), 1024.0f);
                    }
                }
            }
        }
    }

    public CorruptedPawnEntity getHunter() {
        return this.hunt;
    }

    public float calcInfusionRate(Entity parent) {
        if (parent instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)parent;
            return Mth.m_14036_((float)(2.0f - (float)entity.m_21133_((Attribute)ModAttributes.VOIDIC_INFUSION_RES.get())), (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }

    private void refreshEquipmentAttributes(LivingEntity entity) {
        for (EquipmentSlot equipmentSlotType : EquipmentSlot.values()) {
            ItemStack itemstack = entity.m_6844_(equipmentSlotType);
            if (itemstack.m_41619_()) continue;
            entity.m_21204_().m_22161_(itemstack.m_41638_(equipmentSlotType));
            entity.m_21204_().m_22178_(itemstack.m_41638_(equipmentSlotType));
        }
    }

    public float calcParanoiaRate(Entity parent) {
        if (parent instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)parent;
            return Mth.m_14036_((float)(2.0f - (float)entity.m_21133_((Attribute)ModAttributes.VOIDIC_PARANOIA_RES.get())), (float)0.0f, (float)1.0f) * 0.9f;
        }
        return 1.0f;
    }

    public float getInfusion() {
        return this.infusion;
    }

    public void decrementInfusion(float amount) {
        this.decrementInfusion = amount;
    }

    public void setInfusion(float amount) {
        float prev = this.infusion;
        this.infusion = Mth.m_14036_((float)amount, (float)0.0f, (float)600.0f);
        this.dirty = prev != this.infusion;
    }

    public float getParanoia() {
        return this.paranoia;
    }

    public void setParanoia(float amount) {
        float prev = this.paranoia;
        this.paranoia = Mth.m_14036_((float)amount, (float)0.0f, (float)600.0f);
        this.dirty = prev != this.paranoia;
    }

    @Override
    public CompoundTag write(CompoundTag nbt, @Nullable Direction side) {
        nbt.m_128350_("paranoia", this.paranoia);
        nbt.m_128350_("infusion", this.infusion);
        nbt.m_128379_("inPortal", this.inPortal);
        nbt.m_128379_("pleaseLeavePortal", this.pleaseLeavePortal);
        nbt.m_128405_("teleportTick", this.teleportTick);
        return nbt;
    }

    @Override
    public void read(CompoundTag nbt, @Nullable Direction side) {
        this.paranoia = nbt.m_128457_("paranoia");
        this.infusion = nbt.m_128457_("infusion");
        this.inPortal = nbt.m_128471_("inPortal");
        this.pleaseLeavePortal = nbt.m_128471_("pleaseLeavePortal");
        this.teleportTick = nbt.m_128451_("teleportTick");
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.paranoia);
        buffer.writeFloat(this.infusion);
        buffer.writeInt(this.teleportTick);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.paranoia = buffer.readFloat();
        this.infusion = buffer.readFloat();
        this.teleportTick = buffer.readInt();
    }

    @Override
    public void clone(SubCapability.ISubCap.ISubCapData old, boolean death) {
        if (old instanceof Insanity) {
            Insanity o = (Insanity)old;
            if (!death) {
                this.infusion = o.infusion;
                this.paranoia = o.paranoia;
                this.inPortal = o.inPortal;
                this.pleaseLeavePortal = o.pleaseLeavePortal;
                this.teleportTick = o.teleportTick;
            }
        }
    }
}

