/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tamaized.voidscape.registry.ModBlockEntities;
import tamaized.voidscape.registry.ModFluids;
import tamaized.voidscape.registry.ModItems;

public class LiquifierBlockEntity
extends BlockEntity {
    private final LazyOptional<ItemStackHandler> items = LazyOptional.of(() -> new ItemStackHandler(1));
    private final LazyOptional<FluidTank> fluids = LazyOptional.of(() -> new FluidTank(10000, fluidStack -> fluidStack.getFluid() == ModFluids.VOIDIC_SOURCE.get()));
    private int tick;
    private int processTick;

    public LiquifierBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.LIQUIFIER.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.items.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluids.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.items.invalidate();
        this.fluids.invalidate();
        super.invalidateCaps();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.processTick = pTag.m_128451_("processTick");
        ((ItemStackHandler)this.items.resolve().orElseThrow()).deserializeNBT(pTag.m_128469_("inventory"));
        ((FluidTank)this.fluids.resolve().orElseThrow()).readFromNBT(pTag.m_128469_("tank"));
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("processTick", this.processTick);
        pTag.m_128365_("inventory", (Tag)((ItemStackHandler)this.items.resolve().orElseThrow()).serializeNBT());
        pTag.m_128365_("tank", (Tag)((FluidTank)this.fluids.resolve().orElseThrow()).writeToNBT(new CompoundTag()));
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity be) {
        if (!(be instanceof LiquifierBlockEntity)) {
            return;
        }
        LiquifierBlockEntity entity = (LiquifierBlockEntity)be;
        ++entity.tick;
        IFluidHandler fluid = (IFluidHandler)entity.fluids.resolve().orElseThrow();
        IItemHandler item = (IItemHandler)entity.items.resolve().orElseThrow();
        if (fluid.getFluidInTank(0).getAmount() < fluid.getTankCapacity(0) - 250 && item.getStackInSlot(0).m_150930_((Item)ModItems.VOIDIC_CRYSTAL.get())) {
            ++entity.processTick;
            if (entity.processTick >= 80) {
                entity.processTick = 0;
                fluid.fill(new FluidStack((Fluid)ModFluids.VOIDIC_SOURCE.get(), 250), IFluidHandler.FluidAction.EXECUTE);
                item.getStackInSlot(0).m_41774_(1);
            }
        } else {
            entity.processTick = 0;
        }
        if (entity.tick % 20 == 0 && fluid.getFluidInTank(0).getAmount() > 0) {
            for (Direction face : Direction.values()) {
                BlockEntity other = level.m_7702_(blockPos.m_121945_(face));
                if (other == null) continue;
                other.getCapability(ForgeCapabilities.FLUID_HANDLER, face.m_122424_()).ifPresent(cap -> {
                    int amount = cap.fill(new FluidStack(fluid.getFluidInTank(0).getFluid(), Math.min(fluid.getFluidInTank(0).getAmount(), 1000)), IFluidHandler.FluidAction.EXECUTE);
                    fluid.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                });
                if (fluid.getFluidInTank(0).getAmount() <= 0) break;
            }
        }
    }
}

