/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.block;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import tamaized.voidscape.registry.ModBlocks;

public class EtherealPlantBlock
extends BushBlock {
    public static final EnumProperty<State> STATE = EnumProperty.m_61587_((String)"state", State.class);
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);

    public EtherealPlantBlock(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(STATE, (Comparable)((Object)State.VOID)));
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return EtherealPlantBlock.biomeState(state == null ? this.m_49966_() : state, context.m_43725_().m_204166_(context.m_8083_()).m_203543_().map(ResourceKey::m_135782_).orElse(new ResourceLocation("")));
    }

    public static BlockState biomeState(BlockState state, @Nullable ResourceLocation biome) {
        if (biome == null || !biome.m_135827_().equals("voidscape")) {
            return state;
        }
        return switch (biome.m_135815_()) {
            case "null" -> (BlockState)state.m_61124_(STATE, (Comparable)((Object)State.NULL));
            case "overworld" -> (BlockState)state.m_61124_(STATE, (Comparable)((Object)State.OVERWORLD));
            case "nether" -> (BlockState)state.m_61124_(STATE, (Comparable)((Object)State.NETHER));
            case "end" -> (BlockState)state.m_61124_(STATE, (Comparable)((Object)State.END));
            default -> state;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{STATE});
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50752_) || state.m_204336_(BlockTags.f_13062_) || state.m_204336_(BlockTags.f_13077_) || state.m_60713_(Blocks.f_50259_) || state.m_60713_((Block)ModBlocks.NULL_BLACK.get());
    }

    public static enum State implements StringRepresentable
    {
        VOID,
        NULL,
        OVERWORLD,
        NETHER,
        END;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

