/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.platform;

import com.google.common.collect.ImmutableMap;
import com.illusivesoulworks.veinmining.VeinMiningConstants;
import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.services.IPlatform;
import com.illusivesoulworks.veinmining.common.veinmining.VeinMiningPlayers;
import com.illusivesoulworks.veinmining.common.veinmining.enchantment.VeinMiningEnchantment;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class ForgePlatform
implements IPlatform {
    private static final EnchantmentCategory CATEGORY = EnchantmentCategory.create((String)VeinMiningConstants.ENCHANTMENT_ID.toString(), VeinMiningEnchantment::canEnchant);

    @Override
    public Set<String> getBlocksFromTag(ResourceLocation resourceLocation) {
        HashSet<String> result = new HashSet<String>();
        ITagManager tagManager = ForgeRegistries.BLOCKS.tags();
        if (tagManager != null) {
            for (Block block : tagManager.getTag(tagManager.createOptionalTagKey(resourceLocation, new HashSet()))) {
                ResourceLocation rl = ForgeRegistries.BLOCKS.getKey((Object)block);
                if (rl == null) continue;
                result.add(rl.toString());
            }
        }
        return result;
    }

    @Override
    public EnchantmentCategory getEnchantmentCategory() {
        return CATEGORY;
    }

    @Override
    public Optional<Enchantment> getEnchantment(ResourceLocation resourceLocation) {
        return Optional.ofNullable((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(resourceLocation));
    }

    @Override
    public Optional<Item> getItem(ResourceLocation resourceLocation) {
        return Optional.ofNullable((Item)ForgeRegistries.ITEMS.getValue(resourceLocation));
    }

    @Override
    public Optional<Block> getBlock(ResourceLocation resourceLocation) {
        return Optional.ofNullable((Block)ForgeRegistries.BLOCKS.getValue(resourceLocation));
    }

    @Override
    public Optional<ResourceLocation> getResourceLocation(Enchantment enchantment) {
        return Optional.ofNullable(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment));
    }

    @Override
    public Optional<ResourceLocation> getResourceLocation(Item item) {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    @Override
    public Optional<ResourceLocation> getResourceLocation(Block block) {
        return Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    @Override
    public Map<String, Predicate<ItemStack>> buildEnchantableItems() {
        HashMap<String, Predicate<ItemStack>> result = new HashMap<String, Predicate<ItemStack>>();
        result.put("is:tool", ForgePlatform::canToolAction);
        result.put("is:pickaxe", stack -> ForgePlatform.canToolAction(ToolActions.PICKAXE_DIG, stack));
        result.put("is:axe", stack -> ForgePlatform.canToolAction(ToolActions.AXE_DIG, stack));
        result.put("is:hoe", stack -> ForgePlatform.canToolAction(ToolActions.HOE_DIG, stack));
        result.put("is:shovel", stack -> ForgePlatform.canToolAction(ToolActions.SHOVEL_DIG, stack));
        return ImmutableMap.copyOf(result);
    }

    @Override
    public boolean canHarvestDrops(ServerPlayer playerEntity, BlockState state) {
        return ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)playerEntity);
    }

    private static boolean canToolAction(ToolAction toolAction, ItemStack stack) {
        return stack.canPerformAction(toolAction);
    }

    private static boolean canToolAction(ItemStack stack) {
        Set<ToolAction> actions = Set.of(ToolActions.PICKAXE_DIG, ToolActions.AXE_DIG, ToolActions.HOE_DIG, ToolActions.SHOVEL_DIG);
        for (ToolAction action : actions) {
            if (!stack.canPerformAction(action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean harvest(ServerPlayer player, BlockPos pos, BlockPos originPos) {
        ServerLevel world = player.m_284548_();
        BlockState blockstate = world.m_8055_(pos);
        GameType gameType = player.f_8941_.m_9290_();
        int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)gameType, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        BlockEntity blockentity = world.m_7702_(pos);
        Block block = blockstate.m_60734_();
        if ((block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.m_36337_()) {
            world.m_7260_(pos, blockstate, blockstate, 3);
            return false;
        }
        if (player.m_21205_().onBlockStartBreak(pos, (Player)player)) {
            return true;
        }
        if (player.m_36187_((Level)world, pos, gameType)) {
            return false;
        }
        if (gameType.m_46408_()) {
            ForgePlatform.removeBlock((Player)player, pos, false);
        } else {
            BlockPos spawnPos;
            ItemStack itemstack = player.m_21205_();
            ItemStack itemstack1 = itemstack.m_41777_();
            boolean flag1 = blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player);
            itemstack.m_41686_((Level)world, blockstate, pos, (Player)player);
            if (itemstack.m_41619_() && !itemstack1.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
            }
            boolean flag = ForgePlatform.removeBlock((Player)player, pos, flag1);
            BlockPos blockPos = spawnPos = (Boolean)VeinMiningConfig.SERVER.relocateDrops.get() != false ? originPos : pos;
            if (flag && flag1) {
                FoodData foodData = player.m_36324_();
                float currentExhaustion = foodData.m_150380_();
                VeinMiningPlayers.addMiningBlock((Level)world, pos, spawnPos);
                block.m_6240_((Level)world, (Player)player, pos, blockstate, blockentity, itemstack1);
                VeinMiningPlayers.removeMiningBlock((Level)world, pos);
                if (((Boolean)VeinMiningConfig.SERVER.addExhaustion.get()).booleanValue()) {
                    float diff = foodData.m_150380_() - currentExhaustion;
                    foodData.m_150378_(currentExhaustion);
                    foodData.m_38703_((float)((double)diff * (Double)VeinMiningConfig.SERVER.exhaustionMultiplier.get()));
                } else {
                    foodData.m_150378_(currentExhaustion);
                }
            }
            if (flag && exp > 0) {
                blockstate.m_60734_().m_49805_(world, spawnPos, exp);
            }
        }
        return true;
    }

    @Override
    public Set<String> getItemsFromTag(ResourceLocation resourceLocation) {
        HashSet<String> result = new HashSet<String>();
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        if (tagManager != null) {
            for (Item item : tagManager.getTag(tagManager.createOptionalTagKey(resourceLocation, new HashSet()))) {
                ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)item);
                if (rl == null) continue;
                result.add(rl.toString());
            }
        }
        return result;
    }

    @Override
    public List<String> getDefaultItemsConfig() {
        return Arrays.asList("is:tool", "quark:pickarang", "quark:flamerang");
    }

    @Override
    public List<String> getDefaultGroups() {
        return Arrays.asList("#forge:obsidian", "#forge:ores/coal", "#forge:ores/diamond", "#forge:ores/emerald", "#forge:ores/gold", "#forge:ores/iron", "#forge:ores/lapis", "#forge:ores/redstone", "#forge:ores/quartz", "#forge:ores/netherite_scrap", "#forge:ores/copper", "#forge:ores/tin", "#forge:ores/osmium", "#forge:ores/uranium", "#forge:ores/fluorite", "#forge:ores/lead", "#forge:ores/zinc", "#forge:ores/aluminum", "#forge:ores/nickel", "#forge:ores/silver", "#forge:ores/apatite", "#forge:ores/cinnabar", "#forge:ores/niter", "#forge:ores/ruby", "#forge:ores/sapphire", "#forge:ores/sulfur");
    }

    private static boolean removeBlock(Player player, BlockPos pos, boolean canHarvest) {
        Level world = player.m_20193_();
        BlockState state = world.m_8055_(pos);
        boolean removed = state.onDestroyedByPlayer(world, pos, player, canHarvest, world.m_6425_(pos));
        if (removed) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
            if (!world.m_8055_(pos).m_60795_()) {
                world.m_7471_(pos, false);
            }
        }
        return removed;
    }
}

