/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining.logic;

import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.Services;
import com.illusivesoulworks.veinmining.common.veinmining.logic.BlockGroups;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockProcessor {
    private static final Map<String, Boolean> checkedBlocks = new HashMap<String, Boolean>();
    private static final Map<String, Map<String, Boolean>> checkedPairs = new HashMap<String, Map<String, Boolean>>();
    private static final Map<String, Set<String>> checkedTags = new HashMap<String, Set<String>>();

    public static synchronized void rebuild() {
        checkedBlocks.clear();
        checkedPairs.clear();
        checkedTags.clear();
        BlockGroups.init();
    }

    public static boolean isValidTarget(BlockState state, Block source) {
        Block block = state.m_60734_();
        return Services.PLATFORM.getResourceLocation(block).map(resourceLocation -> !state.m_60795_() && checkedBlocks.computeIfAbsent(resourceLocation.toString(), name -> BlockProcessor.checkBlock(state)) != false && BlockProcessor.matches(source, block)).orElse(false);
    }

    private static boolean matches(Block origin, Block target) {
        boolean useOriginKey;
        if (origin == target) {
            return true;
        }
        String originName = Services.PLATFORM.getResourceLocation(origin).map(ResourceLocation::toString).orElse("");
        String targetName = Services.PLATFORM.getResourceLocation(target).map(ResourceLocation::toString).orElse("");
        if (originName.isEmpty() && targetName.isEmpty()) {
            return false;
        }
        boolean bl = useOriginKey = originName.compareTo(targetName) >= 0;
        if (useOriginKey) {
            return checkedPairs.computeIfAbsent(originName, name -> new HashMap()).computeIfAbsent(targetName, name -> BlockProcessor.checkMatch(origin, target));
        }
        return checkedPairs.computeIfAbsent(targetName, name -> new HashMap()).computeIfAbsent(originName, name -> BlockProcessor.checkMatch(origin, target));
    }

    private static boolean checkBlock(BlockState blockState) {
        HashSet<String> ids = new HashSet<String>();
        String blockId = Services.PLATFORM.getResourceLocation(blockState.m_60734_()).map(ResourceLocation::toString).orElse("");
        if (blockId.isEmpty()) {
            return false;
        }
        ids.add(blockId);
        Set tags = checkedTags.computeIfAbsent(blockId, name -> BlockProcessor.getTagsFor(blockState));
        tags.forEach(tag -> ids.add("#" + tag));
        VeinMiningConfig.SERVER.blocksList.clearCache();
        Set configs = (Set)VeinMiningConfig.SERVER.blocksList.getTransformed();
        if (VeinMiningConfig.SERVER.blocksListType.get() == VeinMiningConfig.ListType.DENY) {
            for (String id : configs) {
                if (!ids.contains(id)) continue;
                return false;
            }
            return true;
        }
        for (String id : configs) {
            if (!ids.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getTagsFor(BlockState blockState) {
        HashSet<String> tags = new HashSet<String>();
        BuiltInRegistries.f_256975_.m_203613_().forEach(blockTagKey -> {
            if (blockState.m_204336_(blockTagKey)) {
                tags.add(blockTagKey.f_203868_().toString());
            }
        });
        return tags;
    }

    private static boolean checkMatch(Block origin, Block target) {
        String originName = Services.PLATFORM.getResourceLocation(origin).map(ResourceLocation::toString).orElse("");
        String targetName = Services.PLATFORM.getResourceLocation(target).map(ResourceLocation::toString).orElse("");
        if (originName.isEmpty() || targetName.isEmpty()) {
            return false;
        }
        return BlockGroups.getGroup(originName).contains(targetName);
    }
}

