/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.network;

import com.illusivesoulworks.veinmining.common.network.CPacketState;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class VeinMiningForgeNetwork {
    private static final String PTC_VERSION = "1";
    private static SimpleChannel instance;
    private static int id;

    public static SimpleChannel get() {
        return instance;
    }

    public static void setup() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("veinmining", "main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        VeinMiningForgeNetwork.registerC2S(CPacketState.class, CPacketState::encode, CPacketState::decode, CPacketState::handle);
    }

    public static <M> void registerC2S(Class<M> clazz, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, ServerPlayer> handler) {
        instance.registerMessage(id++, clazz, encoder, decoder, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender != null) {
                    handler.accept(message, sender);
                }
            });
            context.setPacketHandled(true);
        });
    }

    static {
        id = 0;
    }
}

