/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common;

import com.illusivesoulworks.veinmining.common.veinmining.VeinMiningEvents;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeCommonEventsListener {
    @SubscribeEvent
    public void levelTick(TickEvent.LevelTickEvent evt) {
        VeinMiningEvents.tick(evt.level);
    }

    @SubscribeEvent
    public void reload(AddReloadListenerEvent evt) {
        evt.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            @Nonnull
            protected Void prepare(@Nonnull ResourceManager resourceManagerIn, @Nonnull ProfilerFiller profilerIn) {
                return null;
            }

            protected void apply(@Nonnull Void objectIn, @Nonnull ResourceManager resourceManagerIn, @Nonnull ProfilerFiller profilerIn) {
                VeinMiningEvents.reloadDatapack();
            }
        });
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent evt) {
        VeinMiningEvents.reloadDatapack();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void blockBreak(BlockEvent.BreakEvent evt) {
        Player player = evt.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            VeinMiningEvents.blockBreak(player2, evt.getPos(), evt.getState());
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            VeinMiningEvents.playerLoggedOut(player2);
        }
    }
}

