/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dan200.computercraft.shared.ModRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public final class ImpostorShapelessRecipe
extends ShapelessRecipe {
    private final String group;
    private final ItemStack result;

    private ImpostorShapelessRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(id, group, category, result, ingredients);
        this.group = group;
        this.result = result;
    }

    public String m_6076_() {
        return this.group;
    }

    ItemStack getResultItem() {
        return this.result;
    }

    public boolean m_5818_(CraftingContainer inv, Level world) {
        return false;
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPELESS.get();
    }

    public static final class Serializer
    implements RecipeSerializer<ImpostorShapelessRecipe> {
        public ImpostorShapelessRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> ingredients = this.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ImpostorShapelessRecipe(id, group, category, result, ingredients);
        }

        private NonNullList<Ingredient> readIngredients(JsonArray arrays) {
            NonNullList items = NonNullList.m_122779_();
            for (int i = 0; i < arrays.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)arrays.get(i));
                if (ingredient.m_43947_()) continue;
                items.add((Object)ingredient);
            }
            return items;
        }

        public ImpostorShapelessRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int count = buffer.m_130242_();
            NonNullList items = NonNullList.m_122780_((int)count, (Object)Ingredient.f_43901_);
            for (int j = 0; j < items.size(); ++j) {
                items.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new ImpostorShapelessRecipe(id, group, category, result, (NonNullList<Ingredient>)items);
        }

        public void toNetwork(FriendlyByteBuf buffer, ImpostorShapelessRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.getResultItem());
        }
    }
}

