/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.ModRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public final class ImpostorRecipe
extends ShapedRecipe {
    private final String group;
    private final ItemStack result;

    private ImpostorRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, group, category, width, height, ingredients, result);
        this.group = group;
        this.result = result;
    }

    public String m_6076_() {
        return this.group;
    }

    ItemStack getResultItem() {
        return this.result;
    }

    public boolean m_5818_(CraftingContainer inv, Level world) {
        return false;
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPED.get();
    }

    public static class Serializer
    implements RecipeSerializer<ImpostorRecipe> {
        public ImpostorRecipe fromJson(ResourceLocation identifier, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(identifier, json);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ImpostorRecipe(identifier, group, category, recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_(), result);
        }

        public ImpostorRecipe fromNetwork(ResourceLocation identifier, FriendlyByteBuf buf) {
            int width = buf.m_130242_();
            int height = buf.m_130242_();
            String group = buf.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            NonNullList items = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < items.size(); ++k) {
                items.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            return new ImpostorRecipe(identifier, group, category, width, height, (NonNullList<Ingredient>)items, result);
        }

        public void toNetwork(FriendlyByteBuf buf, ImpostorRecipe recipe) {
            buf.m_130130_(recipe.m_44220_());
            buf.m_130130_(recipe.m_44221_());
            buf.m_130070_(recipe.m_6076_());
            buf.m_130068_((Enum)recipe.m_245232_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.getResultItem());
        }
    }
}

