/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class TurtleOverlayRecipe
extends ShapelessRecipe {
    private final ResourceLocation overlay;
    private final ItemStack result;

    public TurtleOverlayRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients, ResourceLocation overlay) {
        super(id, group, category, result, ingredients);
        this.overlay = overlay;
        this.result = result;
    }

    private static ItemStack make(ItemStack stack, ResourceLocation overlay) {
        TurtleItem turtle = (TurtleItem)stack.m_41720_();
        return turtle.create(turtle.getComputerID(stack), turtle.getLabel(stack), turtle.getColour(stack), turtle.getUpgradeWithData(stack, TurtleSide.LEFT), turtle.getUpgradeWithData(stack, TurtleSide.RIGHT), turtle.getFuelLevel(stack), overlay);
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!(stack.m_41720_() instanceof TurtleItem)) continue;
            return TurtleOverlayRecipe.make(stack, this.overlay);
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.TURTLE_OVERLAY.get();
    }

    public static class Serializer
    implements RecipeSerializer<TurtleOverlayRecipe> {
        public TurtleOverlayRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> ingredients = this.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ResourceLocation overlay = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"overlay"));
            ItemStack result = TurtleOverlayRecipe.make(ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result")), overlay);
            return new TurtleOverlayRecipe(id, group, category, result, ingredients, overlay);
        }

        private NonNullList<Ingredient> readIngredients(JsonArray arrays) {
            NonNullList items = NonNullList.m_122779_();
            for (int i = 0; i < arrays.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)arrays.get(i));
                if (ingredient.m_43947_()) continue;
                items.add((Object)ingredient);
            }
            return items;
        }

        public TurtleOverlayRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int count = buffer.m_130242_();
            NonNullList items = NonNullList.m_122780_((int)count, (Object)Ingredient.f_43901_);
            for (int j = 0; j < items.size(); ++j) {
                items.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            ResourceLocation overlay = buffer.m_130281_();
            return new TurtleOverlayRecipe(id, group, category, result, (NonNullList<Ingredient>)items, overlay);
        }

        public void toNetwork(FriendlyByteBuf buffer, TurtleOverlayRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
            buffer.m_130085_(recipe.overlay);
        }
    }
}

