/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.google.common.base.Splitter;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TurtlePlaceCommand
implements TurtleCommand {
    private final InteractDirection direction;
    private final Object[] extraArguments;

    public TurtlePlaceCommand(InteractDirection direction, Object[] arguments) {
        this.direction = direction;
        this.extraArguments = arguments;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        ItemStack stack = turtle.getInventory().m_8020_(turtle.getSelectedSlot());
        if (stack.m_41619_()) {
            return TurtleCommandResult.failure("No items to place");
        }
        Direction direction = this.direction.toWorldDir(turtle);
        BlockPos playerPosition = turtle.getPosition().m_121945_(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, playerPosition, direction);
        turtlePlayer.loadInventory(turtle);
        ErrorMessage message = new ErrorMessage();
        boolean result = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, this.extraArguments, message);
        turtlePlayer.unloadInventory(turtle);
        if (result) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        if (message.message != null) {
            return TurtleCommandResult.failure(message.message);
        }
        return TurtleCommandResult.failure(stack.m_41720_() instanceof BlockItem ? "Cannot place block here" : "Cannot place item here");
    }

    private static boolean deploy(ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, Direction direction, @Nullable Object[] extraArguments, @Nullable ErrorMessage outErrorMessage) {
        if (TurtlePlaceCommand.deployOnEntity(turtle, turtlePlayer)) {
            return true;
        }
        BlockPos position = turtle.getPosition();
        BlockPos newPosition = position.m_121945_(direction);
        return TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition, direction.m_122424_(), extraArguments, true, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.m_121945_(direction), direction.m_122424_(), extraArguments, false, outErrorMessage) || direction.m_122434_() != Direction.Axis.Y && TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.m_7495_(), Direction.UP, extraArguments, false, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, position, direction, extraArguments, false, outErrorMessage);
    }

    private static boolean deployOnEntity(ITurtleAccess turtle, TurtlePlayer turtlePlayer) {
        Vec3 rayDir;
        Vec3 turtlePos;
        Level world = turtle.getLevel();
        HitResult hit = WorldUtil.clip(world, turtlePos = turtlePlayer.player().m_20182_(), rayDir = turtlePlayer.player().m_20252_(1.0f), 1.5, null);
        if (!(hit instanceof EntityHitResult)) {
            return false;
        }
        EntityHitResult entityHit = (EntityHitResult)hit;
        Entity hitEntity = entityHit.m_82443_();
        Vec3 hitPos = entityHit.m_82450_();
        DropConsumer.set(hitEntity, drop -> InventoryUtil.storeItemsFromOffset((Container)turtlePlayer.player().m_150109_(), drop, 1));
        boolean placed = PlatformHelper.get().interactWithEntity(turtlePlayer.player(), hitEntity, hitPos);
        TurtleUtil.stopConsuming(turtle);
        return placed;
    }

    private static boolean canDeployOnBlock(BlockPlaceContext context, ITurtleAccess turtle, TurtlePlayer player, BlockPos position, Direction side, boolean allowReplaceable, @Nullable ErrorMessage outErrorMessage) {
        boolean isProtected;
        ServerLevel world = (ServerLevel)turtle.getLevel();
        if (!world.m_46739_(position) || world.m_46859_(position) || context.m_43722_().m_41720_() instanceof BlockItem && WorldUtil.isLiquidBlock((Level)world, position)) {
            return false;
        }
        BlockState state = world.m_8055_(position);
        boolean replaceable = state.m_60629_(context);
        if (!allowReplaceable && replaceable) {
            return false;
        }
        boolean bl = isProtected = replaceable ? player.isBlockProtected(world, position) : player.isBlockProtected(world, position.m_121945_(side));
        if (isProtected) {
            if (outErrorMessage != null) {
                outErrorMessage.message = "Cannot place in protected area";
            }
            return false;
        }
        return true;
    }

    public static BlockHitResult getHitResult(BlockPos position, Direction side) {
        double hitX = 0.5 + (double)side.m_122429_() * 0.5;
        double hitY = 0.5 + (double)side.m_122430_() * 0.5;
        double hitZ = 0.5 + (double)side.m_122431_() * 0.5;
        if (Math.abs(hitY - 0.5) < 0.01) {
            hitY = 0.45;
        }
        return new BlockHitResult(new Vec3((double)position.m_123341_() + hitX, (double)position.m_123342_() + hitY, (double)position.m_123343_() + hitZ), side, position, false);
    }

    private static boolean deployOnBlock(ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, BlockPos position, Direction side, @Nullable Object[] extraArguments, boolean adjacent, @Nullable ErrorMessage outErrorMessage) {
        Object object;
        Direction playerDir = side.m_122424_();
        BlockPos playerPosition = position.m_121945_(side);
        turtlePlayer.setPosition(turtle, playerPosition, playerDir);
        BlockHitResult hit = TurtlePlaceCommand.getHitResult(position, side);
        UseOnContext context = new UseOnContext((Player)turtlePlayer.player(), InteractionHand.MAIN_HAND, hit);
        if (!TurtlePlaceCommand.canDeployOnBlock(new BlockPlaceContext(context), turtle, turtlePlayer, position, side, adjacent, outErrorMessage)) {
            return false;
        }
        Item item = stack.m_41720_();
        BlockEntity existingTile = turtle.getLevel().m_7702_(position);
        boolean placed = TurtlePlaceCommand.doDeployOnBlock(stack, turtlePlayer, hit, adjacent).m_19077_();
        if (placed && item instanceof SignItem && extraArguments != null && extraArguments.length >= 1 && (object = extraArguments[0]) instanceof String) {
            String message = (String)object;
            Level world = turtle.getLevel();
            BlockEntity tile = world.m_7702_(position);
            if (tile == null || tile == existingTile) {
                tile = world.m_7702_(position.m_121945_(side));
            }
            if (tile instanceof SignBlockEntity) {
                TurtlePlaceCommand.setSignText(world, tile, message);
            }
        }
        return placed;
    }

    private static InteractionResult doDeployOnBlock(ItemStack stack, TurtlePlayer turtlePlayer, BlockHitResult hit, boolean adjacent) {
        InteractionResult result = PlatformHelper.get().useOn(turtlePlayer.player(), stack, hit, adjacent ? x -> x.m_204336_(ComputerCraftTags.Blocks.TURTLE_CAN_USE) : x -> false);
        if (result != InteractionResult.PASS) {
            return result;
        }
        Level level = turtlePlayer.player().m_9236_();
        Item item = stack.m_41720_();
        if (item instanceof BucketItem || item instanceof PlaceOnWaterBlockItem || stack.m_204117_(ComputerCraftTags.Items.TURTLE_CAN_PLACE)) {
            return turtlePlayer.player().f_8941_.m_6261_(turtlePlayer.player(), level, stack, InteractionHand.MAIN_HAND);
        }
        return InteractionResult.PASS;
    }

    private static void setSignText(Level world, BlockEntity tile, String message) {
        SignBlockEntity signTile = (SignBlockEntity)tile;
        List split = Splitter.on((char)'\n').splitToList((CharSequence)message);
        int firstLine = split.size() <= 2 ? 1 : 0;
        SignText signText = new SignText();
        for (int i = 0; i < 4; ++i) {
            if (i < firstLine || i >= firstLine + split.size()) continue;
            String line = (String)split.get(i - firstLine);
            signText.m_276913_(i, (Component)(line.length() > 15 ? Component.m_237113_((String)line.substring(0, 15)) : Component.m_237113_((String)line)));
        }
        signTile.m_276956_(signText, true);
        world.m_7260_(tile.m_58899_(), tile.m_58900_(), tile.m_58900_(), 3);
    }

    private static final class ErrorMessage {
        @Nullable
        String message;

        private ErrorMessage() {
        }
    }
}

