/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlock;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TurtleBlock
extends AbstractComputerBlock<TurtleBlockEntity>
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape DEFAULT_SHAPE = Shapes.m_83048_((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    private final BlockEntityTicker<TurtleBlockEntity> clientTicker = (level, pos, state, computer) -> computer.clientTick();

    public TurtleBlock(BlockBehaviour.Properties settings, ComputerFamily family, RegistryEntry<BlockEntityType<TurtleBlockEntity>> type) {
        super(settings, family, type);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WaterloggableHelpers.WATERLOGGED});
    }

    @Deprecated
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 vec3;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
            vec3 = turtle.getRenderOffset(1.0f);
        } else {
            vec3 = Vec3.f_82478_;
        }
        Vec3 offset = vec3;
        return offset.equals((Object)Vec3.f_82478_) ? DEFAULT_SHAPE : DEFAULT_SHAPE.m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext placement) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placement.m_8125_())).m_61124_((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getFluidStateForPlacement(placement)));
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return WaterloggableHelpers.getFluidState(state);
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction side, BlockState otherState, LevelAccessor world, BlockPos pos, BlockPos otherPos) {
        WaterloggableHelpers.updateShape(state, world, pos);
        return state;
    }

    @Deprecated
    public final void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        TurtleBlockEntity turtle;
        BlockEntity blockEntity;
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TurtleBlockEntity && !(turtle = (TurtleBlockEntity)blockEntity).hasMoved()) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)turtle);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        BlockEntity tile = world.m_7702_(pos);
        if (!world.f_46443_ && tile instanceof TurtleBlockEntity) {
            TurtleSide[] turtleSideArray;
            TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                turtle.setOwningPlayer(player.m_36316_());
            }
            if ((turtleSideArray = stack.m_41720_()) instanceof TurtleItem) {
                ResourceLocation overlay;
                TurtleItem item = (TurtleItem)turtleSideArray;
                for (TurtleSide side : TurtleSide.values()) {
                    turtle.getAccess().setUpgradeWithData(side, item.getUpgradeWithData(stack, side));
                }
                turtle.getAccess().setFuelLevel(item.getFuelLevel(stack));
                int colour = item.getColour(stack);
                if (colour != -1) {
                    turtle.getAccess().setColour(colour);
                }
                if ((overlay = item.getOverlay(stack)) != null) {
                    ((TurtleBrain)turtle.getAccess()).setOverlay(overlay);
                }
            }
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        Entity exploder = explosion.m_253049_();
        if (this.getFamily() == ComputerFamily.ADVANCED || exploder instanceof LivingEntity || exploder instanceof AbstractHurtingProjectile) {
            return 2000.0f;
        }
        return this.f_60444_;
    }

    @Override
    protected ItemStack getItem(AbstractComputerBlockEntity tile) {
        if (!(tile instanceof TurtleBlockEntity)) {
            return ItemStack.f_41583_;
        }
        TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
        ITurtleAccess access = turtle.getAccess();
        return TurtleItem.create(turtle.getComputerID(), turtle.getLabel(), access.getColour(), turtle.getFamily(), TurtleBlock.withPersistedData(access.getUpgradeWithData(TurtleSide.LEFT)), TurtleBlock.withPersistedData(access.getUpgradeWithData(TurtleSide.RIGHT)), access.getFuelLevel(), turtle.getOverlay());
    }

    @Nullable
    private static UpgradeData<ITurtleUpgrade> withPersistedData(@Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        return upgrade == null ? null : UpgradeData.of(upgrade.upgrade(), upgrade.upgrade().getPersistedData(upgrade.data()));
    }

    @Override
    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> m_142354_(Level level, BlockState state, BlockEntityType<U> type) {
        return level.f_46443_ ? BlockEntityHelpers.createTickerHelper(type, (BlockEntityType)this.type.get(), this.clientTicker) : super.m_142354_(level, state, type);
    }
}

