/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.recipe;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.recipe.ComputerConvertRecipe;
import dan200.computercraft.shared.util.RecipeUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public abstract class ComputerFamilyRecipe
extends ComputerConvertRecipe {
    private final ComputerFamily family;

    public ComputerFamilyRecipe(ResourceLocation identifier, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, ComputerFamily family) {
        super(identifier, group, category, width, height, ingredients, result);
        this.family = family;
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public static abstract class Serializer<T extends ComputerFamilyRecipe>
    implements RecipeSerializer<T> {
        protected abstract T create(ResourceLocation var1, String var2, CraftingBookCategory var3, int var4, int var5, NonNullList<Ingredient> var6, ItemStack var7, ComputerFamily var8);

        public T fromJson(ResourceLocation identifier, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            ComputerFamily family = RecipeUtil.getFamily(json, "family");
            RecipeUtil.ShapedTemplate template = RecipeUtil.getTemplate(json);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return this.create(identifier, group, category, template.width(), template.height(), template.ingredients(), result, family);
        }

        public T fromNetwork(ResourceLocation identifier, FriendlyByteBuf buf) {
            int width = buf.m_130242_();
            int height = buf.m_130242_();
            String group = buf.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            ComputerFamily family = (ComputerFamily)buf.m_130066_(ComputerFamily.class);
            return this.create(identifier, group, category, width, height, (NonNullList<Ingredient>)ingredients, result, family);
        }

        public void toNetwork(FriendlyByteBuf buf, T recipe) {
            buf.m_130130_(recipe.m_44220_());
            buf.m_130130_(recipe.m_44221_());
            buf.m_130070_(((ComputerConvertRecipe)((Object)recipe)).m_6076_());
            buf.m_130068_((Enum)recipe.m_245232_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(((ComputerConvertRecipe)((Object)recipe)).getResultItem());
            buf.m_130068_((Enum)((ComputerFamilyRecipe)((Object)recipe)).getFamily());
        }
    }
}

