/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.menu;

import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.upload.FileSlice;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.TransferredFile;
import dan200.computercraft.shared.computer.upload.TransferredFiles;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.platform.PlatformHelper;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInputState<T extends AbstractContainerMenu>
implements ServerInputHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServerInputState.class);
    private final T owner;
    private final IntSet keysDown = new IntOpenHashSet(4);
    private int lastMouseX;
    private int lastMouseY;
    private int lastMouseDown = -1;
    @Nullable
    private UUID toUploadId;
    @Nullable
    private List<FileUpload> toUpload;

    public ServerInputState(T owner) {
        this.owner = owner;
    }

    @Override
    public void queueEvent(String event, @Nullable Object[] arguments) {
        ((ComputerMenu)this.owner).getComputer().queueEvent(event, arguments);
    }

    @Override
    public void keyDown(int key, boolean repeat) {
        this.keysDown.add(key);
        ((ComputerMenu)this.owner).getComputer().keyDown(key, repeat);
    }

    @Override
    public void keyUp(int key) {
        this.keysDown.remove(key);
        ((ComputerMenu)this.owner).getComputer().keyUp(key);
    }

    @Override
    public void mouseClick(int button, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        this.lastMouseDown = button;
        ((ComputerMenu)this.owner).getComputer().mouseClick(button, x, y);
    }

    @Override
    public void mouseUp(int button, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        this.lastMouseDown = -1;
        ((ComputerMenu)this.owner).getComputer().mouseUp(button, x, y);
    }

    @Override
    public void mouseDrag(int button, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        this.lastMouseDown = button;
        ((ComputerMenu)this.owner).getComputer().mouseDrag(button, x, y);
    }

    @Override
    public void mouseScroll(int direction, int x, int y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
        ((ComputerMenu)this.owner).getComputer().mouseScroll(direction, x, y);
    }

    @Override
    public void shutdown() {
        ((ComputerMenu)this.owner).getComputer().shutdown();
    }

    @Override
    public void turnOn() {
        ((ComputerMenu)this.owner).getComputer().turnOn();
    }

    @Override
    public void reboot() {
        ((ComputerMenu)this.owner).getComputer().reboot();
    }

    @Override
    public void startUpload(UUID uuid, List<FileUpload> files) {
        this.toUploadId = uuid;
        this.toUpload = files;
    }

    @Override
    public void continueUpload(UUID uploadId, List<FileSlice> slices) {
        if (this.toUploadId == null || this.toUpload == null || !this.toUploadId.equals(uploadId)) {
            LOG.warn("Invalid continueUpload call, skipping.");
            return;
        }
        for (FileSlice slice : slices) {
            slice.apply(this.toUpload);
        }
    }

    @Override
    public void finishUpload(ServerPlayer uploader, UUID uploadId) {
        if (this.toUploadId == null || this.toUpload == null || this.toUpload.isEmpty() || !this.toUploadId.equals(uploadId)) {
            LOG.warn("Invalid finishUpload call, skipping.");
            return;
        }
        PlatformHelper.get().sendToPlayer(this.finishUpload(uploader), uploader);
    }

    private UploadResultMessage finishUpload(ServerPlayer player) {
        ServerComputer computer = ((ComputerMenu)this.owner).getComputer();
        if (this.toUpload == null) {
            return UploadResultMessage.error(this.owner, UploadResult.COMPUTER_OFF_MSG);
        }
        for (FileUpload upload : this.toUpload) {
            if (upload.checksumMatches()) continue;
            LOG.warn("Checksum failed to match for {}.", (Object)upload.getName());
            return UploadResultMessage.error(this.owner, (Component)Component.m_237115_((String)"gui.computercraft.upload.failed.corrupted"));
        }
        computer.queueEvent("file_transfer", new Object[]{new TransferredFiles(player, (AbstractContainerMenu)this.owner, this.toUpload.stream().map(x -> new TransferredFile(x.getName(), x.getBytes())).collect(Collectors.toList()))});
        return UploadResultMessage.queued(this.owner);
    }

    public void close() {
        ServerComputer computer = ((ComputerMenu)this.owner).getComputer();
        IntIterator keys = this.keysDown.iterator();
        while (keys.hasNext()) {
            computer.keyUp(keys.nextInt());
        }
        if (this.lastMouseDown != -1) {
            computer.mouseUp(this.lastMouseDown, this.lastMouseX, this.lastMouseY);
        }
        this.keysDown.clear();
        this.lastMouseDown = -1;
    }
}

