/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpgradeManager<R extends UpgradeSerialiser<? extends T>, T extends UpgradeBase>
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final String kind;
    private final ResourceKey<Registry<R>> registry;
    private Map<String, UpgradeWrapper<R, T>> current = Collections.emptyMap();
    private Map<T, UpgradeWrapper<R, T>> currentWrappers = Collections.emptyMap();

    public UpgradeManager(String kind, String path, ResourceKey<Registry<R>> registry) {
        super(GSON, path);
        this.kind = kind;
        this.registry = registry;
    }

    @Nullable
    public T get(String id) {
        UpgradeWrapper<R, T> wrapper = this.current.get(id);
        return wrapper == null ? null : (T)wrapper.upgrade();
    }

    @Nullable
    public UpgradeWrapper<R, T> getWrapper(T upgrade) {
        return this.currentWrappers.get(upgrade);
    }

    @Nullable
    public String getOwner(T upgrade) {
        UpgradeWrapper<R, T> wrapper = this.currentWrappers.get(upgrade);
        return wrapper != null ? wrapper.modId() : null;
    }

    @Nullable
    public UpgradeData<T> get(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (UpgradeWrapper<R, T> wrapper : this.current.values()) {
            ItemStack craftingStack = wrapper.upgrade().getCraftingItem();
            if (craftingStack.m_41619_() || craftingStack.m_41720_() != stack.m_41720_() || !wrapper.upgrade().isItemSuitable(stack)) continue;
            return UpgradeData.of(wrapper.upgrade, wrapper.upgrade.getUpgradeData(stack));
        }
        return null;
    }

    public Collection<T> getUpgrades() {
        return this.currentWrappers.keySet();
    }

    public Map<String, UpgradeWrapper<R, T>> getUpgradeWrappers() {
        return this.current;
    }

    protected void apply(Map<ResourceLocation, JsonElement> upgrades, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<String, UpgradeWrapper<R, T>> newUpgrades = new HashMap<String, UpgradeWrapper<R, T>>();
        for (Map.Entry<ResourceLocation, JsonElement> element : upgrades.entrySet()) {
            try {
                this.loadUpgrade(newUpgrades, element.getKey(), element.getValue());
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("Error loading {} {} from JSON file", (Object)this.kind, (Object)element.getKey(), (Object)e);
            }
        }
        this.current = Collections.unmodifiableMap(newUpgrades);
        this.currentWrappers = newUpgrades.values().stream().collect(Collectors.toUnmodifiableMap(UpgradeWrapper::upgrade, x -> x));
        LOGGER.info("Loaded {} {}s", (Object)this.current.size(), (Object)this.kind);
    }

    private void loadUpgrade(Map<String, UpgradeWrapper<R, T>> current, ResourceLocation id, JsonElement json) {
        Object upgrade;
        JsonObject root = GsonHelper.m_13918_((JsonElement)json, (String)"top element");
        if (!PlatformHelper.get().shouldLoadResource(root)) {
            return;
        }
        ResourceLocation serialiserId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)root, (String)"type"));
        UpgradeSerialiser serialiser = (UpgradeSerialiser)PlatformHelper.get().tryGetRegistryObject(this.registry, serialiserId);
        if (serialiser == null) {
            throw new JsonSyntaxException("Unknown upgrade type '" + serialiserId + "'");
        }
        String modId = id.m_135827_();
        if (modId.equals("minecraft") || modId.equals("")) {
            modId = "computercraft";
        }
        if (!(upgrade = serialiser.fromJson(id, root)).getUpgradeID().equals((Object)id)) {
            throw new IllegalArgumentException("Upgrade " + id + " from " + serialiser + " was incorrectly given id " + upgrade.getUpgradeID());
        }
        UpgradeWrapper result = new UpgradeWrapper(id.toString(), upgrade, serialiser, modId);
        current.put(result.id(), result);
    }

    public void loadFromNetwork(Map<String, UpgradeWrapper<R, T>> newUpgrades) {
        this.current = Collections.unmodifiableMap(newUpgrades);
        this.currentWrappers = newUpgrades.values().stream().collect(Collectors.toUnmodifiableMap(UpgradeWrapper::upgrade, x -> x));
    }

    public record UpgradeWrapper<R extends UpgradeSerialiser<? extends T>, T extends UpgradeBase>(String id, T upgrade, R serialiser, String modId) {
    }
}

