/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.pocket.PocketUpgradeDataProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeDataProvider;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.data.RecipeWrapper;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.ColourUtils;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider {
    private final RecipeIngredients ingredients = PlatformHelper.get().getRecipeIngredients();
    private final TurtleUpgradeDataProvider turtleUpgrades;
    private final PocketUpgradeDataProvider pocketUpgrades;

    RecipeProvider(PackOutput output, TurtleUpgradeDataProvider turtleUpgrades, PocketUpgradeDataProvider pocketUpgrades) {
        super(output);
        this.turtleUpgrades = turtleUpgrades;
        this.pocketUpgrades = pocketUpgrades;
    }

    public void m_245200_(Consumer<FinishedRecipe> add) {
        this.basicRecipes(add);
        this.diskColours(add);
        this.pocketUpgrades(add);
        this.turtleUpgrades(add);
        this.turtleOverlays(add);
        RecipeProvider.addSpecial(add, (SimpleCraftingRecipeSerializer)ModRegistry.RecipeSerializers.PRINTOUT.get());
        RecipeProvider.addSpecial(add, (SimpleCraftingRecipeSerializer)ModRegistry.RecipeSerializers.DISK.get());
        RecipeProvider.addSpecial(add, (SimpleCraftingRecipeSerializer)ModRegistry.RecipeSerializers.DYEABLE_ITEM.get());
        RecipeProvider.addSpecial(add, (SimpleCraftingRecipeSerializer)ModRegistry.RecipeSerializers.DYEABLE_ITEM_CLEAR.get());
        RecipeProvider.addSpecial(add, (SimpleCraftingRecipeSerializer)ModRegistry.RecipeSerializers.TURTLE_UPGRADE.get());
        RecipeProvider.addSpecial(add, (SimpleCraftingRecipeSerializer)ModRegistry.RecipeSerializers.POCKET_COMPUTER_UPGRADE.get());
    }

    private void diskColours(Consumer<FinishedRecipe> add) {
        for (Colour colour : Colour.VALUES) {
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.DISK.get())).m_126184_(this.ingredients.redstone()).m_126209_((ItemLike)Items.f_42516_).m_126209_((ItemLike)DyeItem.m_41082_((DyeColor)RecipeProvider.ofColour(colour))).m_126145_("computercraft:disk").m_126132_("has_drive", (CriterionTriggerInstance)RecipeProvider.inventoryChange((ItemLike)ModRegistry.Blocks.DISK_DRIVE.get())).m_126140_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPELESS.get(), add).withResultTag(x -> x.m_128405_("Color", colour.getHex())), new ResourceLocation("computercraft", "disk_" + (colour.ordinal() + 1)));
        }
    }

    private static List<TurtleItem> turtleItems() {
        return List.of((TurtleItem)ModRegistry.Items.TURTLE_NORMAL.get(), (TurtleItem)ModRegistry.Items.TURTLE_ADVANCED.get());
    }

    private void turtleUpgrades(Consumer<FinishedRecipe> add) {
        for (TurtleItem turtleItem : RecipeProvider.turtleItems()) {
            ItemStack base = turtleItem.create(-1, null, -1, null, null, 0, null);
            String nameId = turtleItem.getFamily().name().toLowerCase(Locale.ROOT);
            for (ITurtleUpgrade upgrade : this.turtleUpgrades.getGeneratedUpgrades()) {
                ItemStack result = turtleItem.create(-1, null, -1, null, UpgradeData.ofDefault(upgrade), -1, null);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result.m_41720_()).m_126145_(String.format("%s:turtle_%s", "computercraft", nameId)).m_126130_("#T").m_126127_(Character.valueOf('T'), (ItemLike)base.m_41720_()).m_126127_(Character.valueOf('#'), (ItemLike)upgrade.getCraftingItem().m_41720_()).m_126132_("has_items", (CriterionTriggerInstance)RecipeProvider.inventoryChange(new ItemLike[]{base.m_41720_(), upgrade.getCraftingItem().m_41720_()})).m_126140_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPED.get(), add).withResultTag(result.m_41783_()), new ResourceLocation("computercraft", String.format("turtle_%s/%s/%s", nameId, upgrade.getUpgradeID().m_135827_(), upgrade.getUpgradeID().m_135815_())));
            }
        }
    }

    private static List<PocketComputerItem> pocketComputerItems() {
        return List.of((PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get(), (PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get());
    }

    private void pocketUpgrades(Consumer<FinishedRecipe> add) {
        for (PocketComputerItem pocket : RecipeProvider.pocketComputerItems()) {
            ItemStack base = pocket.create(-1, null, -1, null);
            if (base.m_41619_()) continue;
            String nameId = pocket.getFamily().name().toLowerCase(Locale.ROOT);
            for (IPocketUpgrade upgrade : this.pocketUpgrades.getGeneratedUpgrades()) {
                ItemStack result = pocket.create(-1, null, -1, UpgradeData.ofDefault(upgrade));
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result.m_41720_()).m_126145_(String.format("%s:pocket_%s", "computercraft", nameId)).m_126130_("#").m_126130_("P").m_126127_(Character.valueOf('P'), (ItemLike)base.m_41720_()).m_126127_(Character.valueOf('#'), (ItemLike)upgrade.getCraftingItem().m_41720_()).m_126132_("has_items", (CriterionTriggerInstance)RecipeProvider.inventoryChange(new ItemLike[]{base.m_41720_(), upgrade.getCraftingItem().m_41720_()})).m_126140_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPED.get(), add).withResultTag(result.m_41783_()), new ResourceLocation("computercraft", String.format("pocket_%s/%s/%s", nameId, upgrade.getUpgradeID().m_135827_(), upgrade.getUpgradeID().m_135815_())));
            }
        }
    }

    private void turtleOverlays(Consumer<FinishedRecipe> add) {
        this.turtleOverlay(add, "turtle_trans_overlay", x -> x.m_126132_("has_dye", (CriterionTriggerInstance)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.dye()))).m_206419_(ColourUtils.getDyeTag(DyeColor.LIGHT_BLUE)).m_206419_(ColourUtils.getDyeTag(DyeColor.PINK)).m_206419_(ColourUtils.getDyeTag(DyeColor.WHITE)).m_126209_((ItemLike)Items.f_42398_));
        this.turtleOverlay(add, "turtle_rainbow_overlay", x -> x.m_126132_("has_dye", (CriterionTriggerInstance)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.dye()))).m_206419_(ColourUtils.getDyeTag(DyeColor.RED)).m_206419_(ColourUtils.getDyeTag(DyeColor.ORANGE)).m_206419_(ColourUtils.getDyeTag(DyeColor.YELLOW)).m_206419_(ColourUtils.getDyeTag(DyeColor.GREEN)).m_206419_(ColourUtils.getDyeTag(DyeColor.BLUE)).m_206419_(ColourUtils.getDyeTag(DyeColor.PURPLE)).m_126209_((ItemLike)Items.f_42398_));
    }

    private void turtleOverlay(Consumer<FinishedRecipe> add, String overlay, Consumer<ShapelessRecipeBuilder> build) {
        for (TurtleItem turtleItem : RecipeProvider.turtleItems()) {
            ItemStack base = turtleItem.create(-1, null, -1, null, null, 0, null);
            String nameId = turtleItem.getFamily().name().toLowerCase(Locale.ROOT);
            String group = "%s:turtle_%s_overlay".formatted("computercraft", nameId);
            ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)base.m_41720_()).m_126145_(group).m_126132_("has_turtle", (CriterionTriggerInstance)RecipeProvider.inventoryChange(new ItemLike[]{base.m_41720_()}));
            build.accept(builder);
            builder.m_126209_((ItemLike)base.m_41720_()).m_126140_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.TURTLE_OVERLAY.get(), add).withExtraData(x -> x.addProperty("overlay", new ResourceLocation("computercraft", "block/" + overlay).toString())), new ResourceLocation("computercraft", "turtle_%s_overlays/%s".formatted(nameId, overlay)));
        }
    }

    private void basicRecipes(Consumer<FinishedRecipe> add) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.CABLE.get()), (int)6).m_126130_(" # ").m_126130_("#R#").m_126130_(" # ").m_126124_(Character.valueOf('#'), this.ingredients.stone()).m_126124_(Character.valueOf('R'), this.ingredients.redstone()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_126132_("has_modem", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.COMPUTER_NORMAL.get())).m_126130_("###").m_126130_("#R#").m_126130_("#G#").m_126124_(Character.valueOf('#'), this.ingredients.stone()).m_126124_(Character.valueOf('R'), this.ingredients.redstone()).m_126124_(Character.valueOf('G'), this.ingredients.glassPane()).m_126132_("has_redstone", (CriterionTriggerInstance)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.redstone()))).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.COMPUTER_ADVANCED.get())).m_126130_("###").m_126130_("#R#").m_126130_("#G#").m_126124_(Character.valueOf('#'), this.ingredients.goldIngot()).m_126124_(Character.valueOf('R'), this.ingredients.redstone()).m_126124_(Character.valueOf('G'), this.ingredients.glassPane()).m_126132_("has_components", (CriterionTriggerInstance)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.redstone()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get())).m_126130_("###").m_126130_("#C#").m_126130_("# #").m_126124_(Character.valueOf('#'), this.ingredients.goldIngot()).m_126127_(Character.valueOf('C'), (ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get()).m_126132_("has_components", (CriterionTriggerInstance)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).m_126140_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.COMPUTER_UPGRADE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.ADVANCED)), new ResourceLocation("computercraft", "computer_advanced_upgrade"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.COMPUTER_COMMAND.get())).m_126130_("###").m_126130_("#R#").m_126130_("#G#").m_126124_(Character.valueOf('#'), this.ingredients.goldIngot()).m_126127_(Character.valueOf('R'), (ItemLike)Blocks.f_50272_).m_126124_(Character.valueOf('G'), this.ingredients.glassPane()).m_126132_("has_components", (CriterionTriggerInstance)RecipeProvider.inventoryChange(new ItemLike[]{Blocks.f_50272_})).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.TURTLE_NORMAL.get())).m_126130_("###").m_126130_("#C#").m_126130_("#I#").m_126124_(Character.valueOf('#'), this.ingredients.ironIngot()).m_126127_(Character.valueOf('C'), (ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get()).m_126124_(Character.valueOf('I'), this.ingredients.woodenChest()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get())).m_176498_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.TURTLE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.NORMAL)));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.TURTLE_ADVANCED.get())).m_126130_("###").m_126130_("#C#").m_126130_("#I#").m_126124_(Character.valueOf('#'), this.ingredients.goldIngot()).m_126127_(Character.valueOf('C'), (ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get()).m_126124_(Character.valueOf('I'), this.ingredients.woodenChest()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get())).m_176498_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.TURTLE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.ADVANCED)));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.TURTLE_ADVANCED.get())).m_126130_("###").m_126130_("#C#").m_126130_(" B ").m_126124_(Character.valueOf('#'), this.ingredients.goldIngot()).m_126127_(Character.valueOf('C'), (ItemLike)ModRegistry.Items.TURTLE_NORMAL.get()).m_126124_(Character.valueOf('B'), this.ingredients.goldBlock()).m_126132_("has_components", (CriterionTriggerInstance)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((ItemLike)ModRegistry.Items.TURTLE_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).m_126140_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.COMPUTER_UPGRADE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.ADVANCED)), new ResourceLocation("computercraft", "turtle_advanced_upgrade"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.DISK_DRIVE.get())).m_126130_("###").m_126130_("#R#").m_126130_("#R#").m_126124_(Character.valueOf('#'), this.ingredients.stone()).m_126124_(Character.valueOf('R'), this.ingredients.redstone()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.MONITOR_NORMAL.get())).m_126130_("###").m_126130_("#G#").m_126130_("###").m_126124_(Character.valueOf('#'), this.ingredients.stone()).m_126124_(Character.valueOf('G'), this.ingredients.glassPane()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.MONITOR_ADVANCED.get()), (int)4).m_126130_("###").m_126130_("#G#").m_126130_("###").m_126124_(Character.valueOf('#'), this.ingredients.goldIngot()).m_126124_(Character.valueOf('G'), this.ingredients.glassPane()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get())).m_126130_("###").m_126130_("#A#").m_126130_("#G#").m_126124_(Character.valueOf('#'), this.ingredients.stone()).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42436_).m_126124_(Character.valueOf('G'), this.ingredients.glassPane()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_126132_("has_apple", (CriterionTriggerInstance)RecipeProvider.inventoryChange(new ItemLike[]{Items.f_42436_})).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get())).m_126130_("###").m_126130_("#A#").m_126130_("#G#").m_126124_(Character.valueOf('#'), this.ingredients.goldIngot()).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42436_).m_126124_(Character.valueOf('G'), this.ingredients.glassPane()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_126132_("has_apple", (CriterionTriggerInstance)RecipeProvider.inventoryChange(new ItemLike[]{Items.f_42436_})).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get())).m_126130_("###").m_126130_("#C#").m_126130_("# #").m_126124_(Character.valueOf('#'), this.ingredients.goldIngot()).m_126127_(Character.valueOf('C'), (ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()).m_126132_("has_components", (CriterionTriggerInstance)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).m_126140_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.COMPUTER_UPGRADE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.ADVANCED)), new ResourceLocation("computercraft", "pocket_computer_advanced_upgrade"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.PRINTER.get())).m_126130_("###").m_126130_("#R#").m_126130_("#D#").m_126124_(Character.valueOf('#'), this.ingredients.stone()).m_126124_(Character.valueOf('R'), this.ingredients.redstone()).m_126124_(Character.valueOf('D'), this.ingredients.dye()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.SPEAKER.get())).m_126130_("###").m_126130_("#N#").m_126130_("#R#").m_126124_(Character.valueOf('#'), this.ingredients.stone()).m_126127_(Character.valueOf('N'), (ItemLike)Blocks.f_50065_).m_126124_(Character.valueOf('R'), this.ingredients.redstone()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.WIRED_MODEM.get())).m_126130_("###").m_126130_("#R#").m_126130_("###").m_126124_(Character.valueOf('#'), this.ingredients.stone()).m_126124_(Character.valueOf('R'), this.ingredients.redstone()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_126132_("has_cable", (CriterionTriggerInstance)RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.CABLE.get())).m_176498_(add);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.WIRED_MODEM_FULL.get())).m_126209_((ItemLike)ModRegistry.Items.WIRED_MODEM.get()).m_126132_("has_modem", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).m_126140_(add, new ResourceLocation("computercraft", "wired_modem_full_from"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.WIRED_MODEM.get())).m_126209_((ItemLike)ModRegistry.Blocks.WIRED_MODEM_FULL.get()).m_126132_("has_modem", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).m_126140_(add, new ResourceLocation("computercraft", "wired_modem_full_to"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.WIRELESS_MODEM_NORMAL.get())).m_126130_("###").m_126130_("#E#").m_126130_("###").m_126124_(Character.valueOf('#'), this.ingredients.stone()).m_126124_(Character.valueOf('E'), this.ingredients.enderPearl()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Blocks.WIRELESS_MODEM_ADVANCED.get())).m_126130_("###").m_126130_("#E#").m_126130_("###").m_126124_(Character.valueOf('#'), this.ingredients.goldIngot()).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_126132_("has_wireless", (CriterionTriggerInstance)RecipeProvider.inventoryChange((ItemLike)ModRegistry.Blocks.WIRELESS_MODEM_NORMAL.get())).m_176498_(add);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.f_42680_).m_126184_(this.ingredients.head()).m_126209_((ItemLike)ModRegistry.Items.MONITOR_NORMAL.get()).m_126132_("has_monitor", (CriterionTriggerInstance)RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.MONITOR_NORMAL.get())).m_126140_((Consumer)RecipeWrapper.wrap(RecipeSerializer.f_44077_, add).withResultTag(RecipeProvider.playerHead("Cloudhunter", "6d074736-b1e9-4378-a99b-bd8777821c9c")), new ResourceLocation("computercraft", "skull_cloudy"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.f_42680_).m_126184_(this.ingredients.head()).m_126209_((ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get()).m_126132_("has_computer", (CriterionTriggerInstance)RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get())).m_126140_((Consumer)RecipeWrapper.wrap(RecipeSerializer.f_44077_, add).withResultTag(RecipeProvider.playerHead("dan200", "f3c8d69b-0776-4512-8434-d1b2165909eb")), new ResourceLocation("computercraft", "skull_dan200"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.PRINTED_PAGES.get())).m_126211_((ItemLike)ModRegistry.Items.PRINTED_PAGE.get(), 2).m_126184_(this.ingredients.string()).m_126132_("has_printer", (CriterionTriggerInstance)RecipeProvider.inventoryChange((ItemLike)ModRegistry.Blocks.PRINTER.get())).m_176498_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPELESS.get(), add));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.PRINTED_BOOK.get())).m_126184_(this.ingredients.leather()).m_126211_((ItemLike)ModRegistry.Items.PRINTED_PAGE.get(), 1).m_126184_(this.ingredients.string()).m_126132_("has_printer", (CriterionTriggerInstance)RecipeProvider.inventoryChange((ItemLike)ModRegistry.Blocks.PRINTER.get())).m_176498_((Consumer)RecipeWrapper.wrap((RecipeSerializer)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPELESS.get(), add));
    }

    private static DyeColor ofColour(Colour colour) {
        return DyeColor.m_41053_((int)(15 - colour.ordinal()));
    }

    private static InventoryChangeTrigger.TriggerInstance inventoryChange(TagKey<Item> stack) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{RecipeProvider.itemPredicate(stack)});
    }

    private static InventoryChangeTrigger.TriggerInstance inventoryChange(ItemLike ... stack) {
        return InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])stack);
    }

    private static InventoryChangeTrigger.TriggerInstance inventoryChange(ItemPredicate ... items) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])items);
    }

    private static ItemPredicate itemPredicate(ItemLike item) {
        return ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_();
    }

    private static ItemPredicate itemPredicate(TagKey<Item> item) {
        return ItemPredicate.Builder.m_45068_().m_204145_(item).m_45077_();
    }

    private static ItemPredicate itemPredicate(Ingredient ingredient) {
        JsonElement json = ingredient.m_43942_();
        if (!(json instanceof JsonObject)) {
            throw new IllegalStateException("Unknown ingredient " + json);
        }
        JsonObject object = (JsonObject)json;
        if (object.has("item")) {
            return RecipeProvider.itemPredicate((ItemLike)ShapedRecipe.m_151278_((JsonObject)object));
        }
        if (object.has("tag")) {
            return RecipeProvider.itemPredicate((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"tag"))));
        }
        throw new IllegalArgumentException("Unknown ingredient " + json);
    }

    private static CompoundTag playerHead(String name, String uuid) {
        CompoundTag owner = new CompoundTag();
        owner.m_128359_("Name", name);
        owner.m_128359_("Id", uuid);
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("SkullOwner", (Tag)owner);
        return tag;
    }

    private static Consumer<JsonObject> family(ComputerFamily family) {
        return json -> json.addProperty("family", family.toString());
    }

    private static void addSpecial(Consumer<FinishedRecipe> add, SimpleCraftingRecipeSerializer<?> special) {
        SpecialRecipeBuilder.m_245676_(special).m_126359_(add, RegistryWrappers.RECIPE_SERIALIZERS.getKey((RecipeSerializer<?>)special).toString());
    }
}

