/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.core.filesystem.ArchiveMount;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.util.Nullability;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;

public class JarMount
extends ArchiveMount<FileEntry>
implements Closeable {
    private final ZipFile zip;

    public JarMount(File jarFile, String subPath) throws IOException {
        if (!jarFile.exists() || jarFile.isDirectory()) {
            throw new FileNotFoundException("Cannot find " + jarFile);
        }
        try {
            this.zip = new ZipFile(jarFile);
        }
        catch (IOException e) {
            throw new IOException("Error loading zip file", e);
        }
        if (this.zip.getEntry(subPath) == null) {
            this.zip.close();
            throw new FileNotFoundException("Zip does not contain path");
        }
        this.root = new FileEntry("");
        Enumeration<? extends ZipEntry> zipEntries = this.zip.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            String entryPath = entry.getName();
            if (!entryPath.startsWith(subPath)) continue;
            String localPath = FileSystem.toLocal(entryPath, subPath);
            this.create(entry, localPath);
        }
    }

    private void create(ZipEntry entry, String localPath) {
        FileEntry lastEntry = Nullability.assertNonNull((FileEntry)this.root);
        int lastIndex = 0;
        while (lastIndex < localPath.length()) {
            FileEntry nextEntry;
            int nextIndex = localPath.indexOf(47, lastIndex);
            if (nextIndex < 0) {
                nextIndex = localPath.length();
            }
            String part = localPath.substring(lastIndex, nextIndex);
            if (lastEntry.children == null) {
                lastEntry.children = new HashMap(0);
            }
            if ((nextEntry = (FileEntry)lastEntry.children.get(part)) == null || !nextEntry.isDirectory()) {
                nextEntry = new FileEntry(localPath.substring(0, nextIndex));
                lastEntry.children.put(part, nextEntry);
            }
            lastEntry = nextEntry;
            lastIndex = nextIndex + 1;
        }
        lastEntry.setup(entry);
    }

    @Override
    protected long getSize(FileEntry file) throws FileOperationException {
        if (file.zipEntry == null) {
            throw new FileOperationException(file.path, "No such file");
        }
        return file.zipEntry.getSize();
    }

    @Override
    protected byte[] getContents(FileEntry file) throws FileOperationException {
        byte[] byArray;
        block9: {
            if (file.zipEntry == null) {
                throw new FileOperationException(file.path, "No such file");
            }
            InputStream stream = this.zip.getInputStream(file.zipEntry);
            try {
                byArray = stream.readAllBytes();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileOperationException(file.path, "No such file");
                }
            }
            stream.close();
        }
        return byArray;
    }

    @Override
    public BasicFileAttributes getAttributes(FileEntry file) throws FileOperationException {
        if (file.zipEntry == null) {
            throw new FileOperationException(file.path, "No such file");
        }
        return new ZipEntryAttributes(file.zipEntry);
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    protected static class FileEntry
    extends ArchiveMount.FileEntry<FileEntry> {
        @Nullable
        ZipEntry zipEntry;

        protected FileEntry(String path) {
            super(path);
        }

        void setup(ZipEntry entry) {
            this.zipEntry = entry;
            this.size = entry.getSize();
            if (this.children == null && entry.isDirectory()) {
                this.children = new HashMap(0);
            }
        }
    }

    private static class ZipEntryAttributes
    implements BasicFileAttributes {
        private final ZipEntry entry;
        private static final FileTime EPOCH = FileTime.from(Instant.EPOCH);

        ZipEntryAttributes(ZipEntry entry) {
            this.entry = entry;
        }

        @Override
        public FileTime lastModifiedTime() {
            return ZipEntryAttributes.orEpoch(this.entry.getLastModifiedTime());
        }

        @Override
        public FileTime lastAccessTime() {
            return ZipEntryAttributes.orEpoch(this.entry.getLastAccessTime());
        }

        @Override
        public FileTime creationTime() {
            FileTime time = this.entry.getCreationTime();
            return time == null ? this.lastModifiedTime() : time;
        }

        @Override
        public boolean isRegularFile() {
            return !this.entry.isDirectory();
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return this.entry.getSize();
        }

        @Override
        @Nullable
        public Object fileKey() {
            return null;
        }

        private static FileTime orEpoch(@Nullable FileTime time) {
            return time == null ? EPOCH : time;
        }
    }
}

