/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.core.filesystem.ChannelWrapper;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.MountWrapper;
import dan200.computercraft.core.filesystem.TrackingCloseable;
import dan200.computercraft.core.util.IoUtil;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class FileSystemWrapper<T extends Closeable>
implements TrackingCloseable {
    private final FileSystem fileSystem;
    final MountWrapper mount;
    private final ChannelWrapper<T> closeable;
    final WeakReference<FileSystemWrapper<?>> self;
    private boolean isOpen = true;

    FileSystemWrapper(FileSystem fileSystem, MountWrapper mount, ChannelWrapper<T> closeable, ReferenceQueue<FileSystemWrapper<?>> queue) {
        this.fileSystem = fileSystem;
        this.mount = mount;
        this.closeable = closeable;
        this.self = new WeakReference(this, queue);
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
        this.fileSystem.removeFile(this);
        this.closeable.close();
    }

    void closeExternally() {
        this.isOpen = false;
        IoUtil.closeQuietly(this.closeable);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    public T get() {
        return this.closeable.get();
    }
}

