/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.core.asm.Generator;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.asm.IntCache;
import dan200.computercraft.core.asm.MethodSupplierImpl;
import dan200.computercraft.core.asm.ResultHelpers;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.methods.PeripheralMethod;
import java.util.List;
import java.util.Objects;

public class PeripheralMethodSupplier {
    private static final Generator<PeripheralMethod> GENERATOR = new Generator<PeripheralMethod>(PeripheralMethod.class, List.of(ILuaContext.class, IComputerAccess.class), m -> (target, context, computer, args) -> {
        IArguments escArgs = args.escapes();
        return context.executeMainThreadTask(() -> ResultHelpers.checkNormalResult(m.apply(target, context, computer, escArgs)));
    });
    private static final IntCache<PeripheralMethod> DYNAMIC = new IntCache<PeripheralMethod>(method -> (instance, context, computer, args) -> ((IDynamicPeripheral)instance).callMethod(computer, context, method, args));

    public static MethodSupplier<PeripheralMethod> create(List<GenericMethod> genericMethods) {
        return new MethodSupplierImpl<PeripheralMethod>(genericMethods, GENERATOR, DYNAMIC, x -> {
            String[] stringArray;
            if (x instanceof IDynamicPeripheral) {
                IDynamicPeripheral dynamic = (IDynamicPeripheral)x;
                stringArray = Objects.requireNonNull(dynamic.getMethodNames(), "Dynamic methods cannot be null");
            } else {
                stringArray = null;
            }
            return stringArray;
        });
    }
}

