/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.IDynamicLuaObject;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.core.asm.Generator;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.asm.IntCache;
import dan200.computercraft.core.asm.MethodSupplierImpl;
import dan200.computercraft.core.asm.ResultHelpers;
import dan200.computercraft.core.methods.LuaMethod;
import dan200.computercraft.core.methods.MethodSupplier;
import java.util.List;
import java.util.Objects;

public final class LuaMethodSupplier {
    private static final Generator<LuaMethod> GENERATOR = new Generator<LuaMethod>(LuaMethod.class, List.of(ILuaContext.class), m -> (target, context, args) -> {
        IArguments escArgs = args.escapes();
        return context.executeMainThreadTask(() -> ResultHelpers.checkNormalResult(m.apply(target, context, escArgs)));
    });
    private static final IntCache<LuaMethod> DYNAMIC = new IntCache<LuaMethod>(method -> (instance, context, args) -> ((IDynamicLuaObject)instance).callMethod(context, method, args));

    private LuaMethodSupplier() {
    }

    public static MethodSupplier<LuaMethod> create(List<GenericMethod> genericMethods) {
        return new MethodSupplierImpl<LuaMethod>(genericMethods, GENERATOR, DYNAMIC, x -> {
            String[] stringArray;
            if (x instanceof IDynamicLuaObject) {
                IDynamicLuaObject dynamic = (IDynamicLuaObject)x;
                stringArray = Objects.requireNonNull(dynamic.getMethodNames(), "Dynamic methods cannot be null");
            } else {
                stringArray = null;
            }
            return stringArray;
        });
    }
}

