/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.websocket;

import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.websocket.Websocket;
import dan200.computercraft.core.metrics.Metrics;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;

public class WebsocketHandler
extends SimpleChannelInboundHandler<Object> {
    private final Websocket websocket;
    private final Options options;
    private boolean handshakeComplete = false;

    public WebsocketHandler(Websocket websocket, Options options) {
        this.websocket = websocket;
        this.options = options;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.fail("Connection closed");
        super.channelInactive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            this.websocket.success(ctx.channel(), this.options);
            this.handshakeComplete = true;
        } else if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT) {
            this.websocket.failure("Timed out");
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (this.websocket.isClosed()) {
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ")");
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            String data = textFrame.text();
            this.websocket.environment().observe(Metrics.WEBSOCKET_INCOMING, data.length());
            this.websocket.environment().queueEvent("websocket_message", this.websocket.address(), data, false);
        } else if (frame instanceof BinaryWebSocketFrame) {
            byte[] converted = NetworkUtils.toBytes(frame.content());
            this.websocket.environment().observe(Metrics.WEBSOCKET_INCOMING, converted.length);
            this.websocket.environment().queueEvent("websocket_message", this.websocket.address(), converted, true);
        } else if (frame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            this.websocket.close(closeFrame.statusCode(), closeFrame.reasonText());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
        this.fail(NetworkUtils.toFriendlyError(cause));
    }

    private void fail(String message) {
        if (this.handshakeComplete) {
            this.websocket.close(-1, message);
        } else {
            this.websocket.failure(message);
        }
    }
}

