/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.client;

import com.mojang.math.Transformation;
import dan200.computercraft.impl.client.ClientPlatformHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class TransformedModel {
    private final BakedModel model;
    private final Transformation matrix;

    public TransformedModel(BakedModel model, Transformation matrix) {
        this.model = Objects.requireNonNull(model);
        this.matrix = Objects.requireNonNull(matrix);
    }

    public TransformedModel(BakedModel model) {
        this.model = Objects.requireNonNull(model);
        this.matrix = Transformation.m_121093_();
    }

    public static TransformedModel of(ModelResourceLocation location) {
        ModelManager modelManager = Minecraft.m_91087_().m_91304_();
        return new TransformedModel(modelManager.m_119422_(location));
    }

    public static TransformedModel of(ResourceLocation location) {
        ModelManager modelManager = Minecraft.m_91087_().m_91304_();
        return new TransformedModel(ClientPlatformHelper.get().getModel(modelManager, location));
    }

    public static TransformedModel of(ItemStack item, Transformation transform) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(item);
        return new TransformedModel(model, transform);
    }

    public BakedModel getModel() {
        return this.model;
    }

    public Transformation getMatrix() {
        return this.matrix;
    }
}

