/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.animations.BodyPart;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MapHoldingAnimation
extends BasicAnimation {
    private Set<Item> compatibleMaps = new HashSet<Item>();
    private final BodyPart[] bothHands = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM};
    private BodyPart[] target = this.bothHands;

    @Override
    public boolean isEnabled() {
        this.bind();
        return NEAnimationsLoader.config.enableInWorldMapRendering || !this.compatibleMaps.isEmpty();
    }

    private void bind() {
        this.compatibleMaps.clear();
        Item invalid = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("minecraft", "air"));
        this.compatibleMaps.add((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("minecraft", "filled_map")));
        Item antiqueAtlas = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("antiqueatlas", "antique_atlas"));
        if (invalid != antiqueAtlas) {
            this.compatibleMaps.add(antiqueAtlas);
            NEAnimationsLoader.LOGGER.info("Added AntiqueAtlas support to Not Enough Animations!");
        }
    }

    @Override
    public boolean isValid(AbstractClientPlayer entity, PlayerData data) {
        ItemStack itemInMainHand = entity.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack itemInOffHand = entity.m_21120_(InteractionHand.OFF_HAND);
        if (this.compatibleMaps.contains(itemInMainHand.m_41720_()) && itemInOffHand.m_41619_()) {
            this.target = this.bothHands;
            return true;
        }
        if (this.compatibleMaps.contains(itemInMainHand.m_41720_()) && !itemInOffHand.m_41619_()) {
            this.target = entity.m_5737_() == HumanoidArm.RIGHT ? this.right : this.left;
            return true;
        }
        if (this.compatibleMaps.contains(itemInOffHand.m_41720_()) && !itemInOffHand.m_41619_()) {
            this.target = entity.m_5737_() == HumanoidArm.RIGHT ? this.left : this.right;
            return true;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayer entity, PlayerData data) {
        return this.target;
    }

    @Override
    public int getPriority(AbstractClientPlayer entity, PlayerData data) {
        return 300;
    }

    @Override
    public void apply(AbstractClientPlayer entity, PlayerData data, PlayerModel<AbstractClientPlayer> model, BodyPart part, float delta, float tickCounter) {
        HumanoidArm arm;
        HumanoidArm humanoidArm = arm = part == BodyPart.LEFT_ARM ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        if (this.target == this.bothHands) {
            AnimationUtil.applyArmTransforms(model, arm, -Mth.m_14179_((float)(-1.0f * (entity.m_146909_() - 90.0f) / 180.0f), (float)0.5f, (float)1.5f), -0.4f, 0.3f);
            return;
        }
        AnimationUtil.applyArmTransforms(model, arm, -Mth.m_14179_((float)(-1.0f * (entity.m_146909_() - 90.0f) / 180.0f), (float)0.5f, (float)1.5f), 0.0f, 0.3f);
    }
}

