/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.belt;

import artifacts.component.SwimData;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.item.wearable.necklace.CharmOfSinkingItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModKeyMappings;
import artifacts.registry.ModSoundEvents;
import dev.architectury.event.events.common.TickEvent;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HeliumFlamingoItem
extends WearableArtifactItem {
    public HeliumFlamingoItem() {
        TickEvent.PLAYER_PRE.register(this::onHeliumFlamingoTick);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() <= 0;
    }

    @Override
    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        tooltip.add(this.tooltipLine("swimming", new Object[0]));
        tooltip.add(this.tooltipLine("keymapping", ModKeyMappings.getHeliumFlamingoKey().m_90863_()));
    }

    @Override
    @NotNull
    public SoundEvent getEquipSound() {
        return (SoundEvent)ModSoundEvents.POP.get();
    }

    private void onHeliumFlamingoTick(Player player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((LivingEntity)player);
        if (swimData == null) {
            return;
        }
        int maxFlightTime = Math.max(1, ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() * 20);
        int rechargeTime = Math.max(20, ModGameRules.HELIUM_FLAMINGO_RECHARGE_DURATION.get() * 20);
        if (swimData.isSwimming()) {
            if (!((WearableArtifactItem)((Object)ModItems.HELIUM_FLAMINGO.get())).isEquippedBy((LivingEntity)player) || swimData.getSwimTime() > maxFlightTime || player.m_20069_() && !player.m_6069_() && !CharmOfSinkingItem.shouldSink((LivingEntity)player) || (!player.m_20069_() || CharmOfSinkingItem.shouldSink((LivingEntity)player)) && player.m_20096_()) {
                swimData.setSwimming(false);
                if (!player.m_20096_() && !player.m_20069_()) {
                    player.m_5496_((SoundEvent)ModSoundEvents.POP.get(), 0.5f, 0.75f);
                }
            }
            if (((WearableArtifactItem)((Object)ModItems.HELIUM_FLAMINGO.get())).isEquippedBy((LivingEntity)player) && !PlatformServices.platformHelper.isEyeInWater(player) && !player.m_150110_().f_35934_) {
                swimData.setSwimTime(swimData.getSwimTime() + 1);
            }
        } else if (swimData.getSwimTime() < 0) {
            swimData.setSwimTime(swimData.getSwimTime() < -rechargeTime ? -rechargeTime : swimData.getSwimTime() + 1);
        }
    }
}

