/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import artifacts.item.wearable.WearableArtifactItem;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public abstract class AttributeModifyingItem
extends WearableArtifactItem {
    private final Attribute attribute;
    protected final UUID modifierId;
    protected final String modifierName;

    public AttributeModifyingItem(Attribute attribute, UUID modifierId, String modifierName) {
        this.attribute = attribute;
        this.modifierId = modifierId;
        this.modifierName = modifierName;
    }

    @Override
    protected boolean isCosmetic() {
        return this.getAmount() <= 0.0;
    }

    private AttributeModifier createModifier() {
        return new AttributeModifier(this.modifierId, this.modifierName, this.getAmount(), AttributeModifier.Operation.ADDITION);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public abstract double getAmount();

    protected void onAttributeUpdated(LivingEntity entity) {
    }

    @Override
    public void onEquip(LivingEntity entity, ItemStack stack) {
        AttributeInstance attributeInstance;
        super.onEquip(entity, stack);
        if (!entity.m_9236_().m_5776_() && (attributeInstance = entity.m_21051_(this.attribute)) != null) {
            attributeInstance.m_22120_(this.modifierId);
            AttributeModifier modifier = this.createModifier();
            attributeInstance.m_22125_(modifier);
            this.onAttributeUpdated(entity);
        }
    }

    @Override
    public void wornTick(LivingEntity entity, ItemStack stack) {
        AttributeModifier existingModifier;
        AttributeInstance attributeInstance;
        if (!(entity.m_9236_().m_5776_() || (attributeInstance = entity.m_21051_(this.attribute)) == null || (existingModifier = attributeInstance.m_22111_(this.modifierId)) != null && existingModifier.m_22218_() == this.getAmount())) {
            attributeInstance.m_22120_(this.modifierId);
            attributeInstance.m_22125_(this.createModifier());
            this.onAttributeUpdated(entity);
        }
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        AttributeInstance attributeInstance;
        if (!entity.m_9236_().m_5776_() && (attributeInstance = entity.m_21051_(this.attribute)) != null) {
            attributeInstance.m_22120_(this.modifierId);
            this.onAttributeUpdated(entity);
        }
    }
}

