/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.friendlyfire;

import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.friendlyfire.Config;
import net.darkhax.friendlyfire.Constants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FriendlyFireCommon {
    private static final TagKey<Item> BYPASS_PET = Services.TAGS.itemTag(new ResourceLocation("friendlyfire", "bypass_pet"));
    private static final TagKey<Item> BYPASS_ALL = Services.TAGS.itemTag(new ResourceLocation("friendlyfire", "bypass_all_protection"));
    private static final TagKey<EntityType<?>> GENERAL_PROTECTION = Services.TAGS.entityTag(new ResourceLocation("friendlyfire", "general_protection"));
    private static final TagKey<EntityType<?>> PLAYER_PROTECTION = Services.TAGS.entityTag(new ResourceLocation("friendlyfire", "player_protection"));
    private static final TagKey<EntityType<?>> BYPASSED_PROTECTION = Services.TAGS.entityTag(new ResourceLocation("friendlyfire", "bypassed_entity_types"));
    private static final Config CONFIG = Config.load(new File(Services.PLATFORM.getConfigDirectory(), "friendlyfire.json"));

    public static void init() {
        Constants.LOG.debug("Protect children = {}", (Object)FriendlyFireCommon.CONFIG.protectChildren);
        Constants.LOG.debug("Protect pets from owner = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromOwner);
        Constants.LOG.debug("Protect pets from pets = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromPets);
        Constants.LOG.debug("Reflect damage = {}", (Object)FriendlyFireCommon.CONFIG.reflectDamage);
    }

    public static boolean preventAttack(Entity target, DamageSource source, float amount) {
        boolean preventDamage;
        Entity attacker = source.m_7639_();
        boolean bl = preventDamage = source != null && FriendlyFireCommon.isProtected(target, attacker, amount);
        if (preventDamage && attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            if (FriendlyFireCommon.CONFIG.displayHitWarning) {
                player.m_5661_((Component)Component.m_237110_((String)"notif.friendlyfire.protected", (Object[])new Object[]{target.m_7755_()}), true);
            }
        }
        return preventDamage;
    }

    private static boolean isProtected(Entity target, Entity attacker, float amount) {
        AgeableMob agable;
        UUID ownerId;
        ItemStack heldItem;
        if (target.m_6095_().m_204039_(BYPASSED_PROTECTION)) {
            return false;
        }
        if (target == null || attacker == null || attacker.m_6047_()) {
            return false;
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            v0 = attackerLiving.m_21205_();
        } else {
            v0 = heldItem = ItemStack.f_41583_;
        }
        if (heldItem.m_204117_(BYPASS_ALL)) {
            return false;
        }
        if (target.m_6095_().m_204039_(GENERAL_PROTECTION)) {
            return true;
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (target.m_6095_().m_204039_(PLAYER_PROTECTION)) {
                return true;
            }
        }
        if ((ownerId = FriendlyFireCommon.getOwner(target)) != null && !heldItem.m_204117_(BYPASS_PET)) {
            if (FriendlyFireCommon.CONFIG.protectPetsFromOwner && ownerId.equals(attacker.m_20148_())) {
                if (FriendlyFireCommon.CONFIG.reflectDamage) {
                    attacker.m_6469_(attacker.m_9236_().m_269111_().m_269264_(), amount);
                }
                return true;
            }
            if (FriendlyFireCommon.CONFIG.protectPetsFromPets && ownerId.equals(FriendlyFireCommon.getOwner(attacker))) {
                return true;
            }
        }
        return FriendlyFireCommon.CONFIG.protectChildren && !(target instanceof Enemy) && target instanceof AgeableMob && (agable = (AgeableMob)target).m_6162_() && !attacker.m_6047_();
    }

    @Nullable
    private static UUID getOwner(Entity entity) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            return ownable.m_21805_();
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            return horse.m_21805_();
        }
        return null;
    }
}

