/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages;

import java.util.ArrayList;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.itemstages.ISTextHelper;
import net.darkhax.itemstages.Restriction;
import net.darkhax.itemstages.RestrictionManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="itemstages")
public class ItemStages {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Item Stages");

    public ItemStages() {
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
        MinecraftForge.EVENT_BUS.addListener(this::onItemPickup);
        MinecraftForge.EVENT_BUS.addListener(this::onItemUsed);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityHurt);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListeners);
        if (FMLEnvironment.dist.isClient()) {
            MinecraftForge.EVENT_BUS.addListener(this::onItemTooltip);
        }
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)RestrictionManager.INSTANCE);
    }

    private void onEntityHurt(LivingAttackEvent event) {
        ItemStack stack;
        Player player;
        Restriction restriction;
        Entity entity;
        if (this.canAffectPlayer(event.getSource()) && (entity = event.getSource().m_7639_()) instanceof Player && (restriction = RestrictionManager.INSTANCE.getRestriction(player = (Player)entity, stack = player.m_21205_())) != null && restriction.shouldPreventAttacking()) {
            event.setCanceled(true);
            Component message = restriction.getAttackMessage(stack);
            player.m_213846_(message);
        }
    }

    private void onItemUsed(PlayerInteractEvent event) {
        if (event.isCancelable() && this.canAffectPlayer(event.getEntity())) {
            ItemStack stack = event.getItemStack();
            Restriction restriction = RestrictionManager.INSTANCE.getRestriction(event.getEntity(), stack);
            if (restriction != null && restriction.shouldPreventUsing()) {
                event.setCanceled(true);
                Component message = restriction.getUsageMessage(stack);
                event.getEntity().m_213846_(message);
            }
        }
    }

    private void onItemPickup(EntityItemPickupEvent event) {
        if (this.canAffectPlayer(event.getEntity())) {
            ItemStack stack = event.getItem().m_32055_();
            Restriction restriction = RestrictionManager.INSTANCE.getRestriction(event.getEntity(), stack);
            if (restriction != null && restriction.shouldPreventPickup()) {
                event.setCanceled(true);
                event.getItem().m_32010_(restriction.getPickupDelay());
                Component message = restriction.getPickupMessage(stack);
                event.getEntity().m_213846_(message);
            }
        }
    }

    private void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player != null && !event.player.m_9236_().f_46443_ && !(event.player instanceof FakePlayer)) {
            Player player = event.player;
            IStageData stageData = GameStageHelper.getPlayerData((Player)player);
            Inventory inv = player.m_150109_();
            int armorStart = inv.f_35974_.size();
            int armorEnd = armorStart + inv.f_35975_.size();
            for (int slot = 0; slot < inv.m_6643_(); ++slot) {
                Component message;
                Restriction restriction;
                ItemStack slotContent = inv.m_8020_(slot);
                if (slotContent.m_41619_()) continue;
                if (slot >= armorStart && slot <= armorEnd) {
                    restriction = RestrictionManager.INSTANCE.getEquipmentRestriction(player, stageData, slotContent);
                    if (restriction == null || !restriction.shouldPreventEquipment()) continue;
                    inv.m_6836_(slot, ItemStack.f_41583_);
                    player.m_36176_(slotContent, false);
                    message = restriction.getDropMessage(slotContent);
                    if (message == null) continue;
                    player.m_213846_(message);
                    continue;
                }
                restriction = RestrictionManager.INSTANCE.getInventoryRestriction(player, stageData, slotContent);
                if (restriction == null || !restriction.shouldPreventInventory()) continue;
                inv.m_6836_(slot, ItemStack.f_41583_);
                player.m_36176_(slotContent, false);
                message = restriction.getDropMessage(slotContent);
                if (message == null) continue;
                player.m_213846_(message);
            }
        }
    }

    private void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack;
        IStageData data;
        Player player;
        Restriction restriction;
        if (event.getEntity() != null && (restriction = RestrictionManager.INSTANCE.getRestriction(player = event.getEntity(), data = GameStageSaveHandler.getClientData(), stack = event.getItemStack())) != null) {
            event.getToolTip().clear();
            Component hiddenName = restriction.getHiddenName(stack);
            if (hiddenName != null) {
                event.getToolTip().add(hiddenName);
            }
            if (event.getFlags().m_7050_()) {
                ArrayList<Component> stages = new ArrayList<Component>();
                MutableComponent sep = Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY);
                for (String stage : restriction.getStages()) {
                    stages.add((Component)Component.m_237113_((String)stage).m_130940_(data.hasStage(stage) ? ChatFormatting.GREEN : ChatFormatting.RED));
                }
                MutableComponent desc = Component.m_237110_((String)"tooltip.itemstages.item.description", (Object[])new Object[]{ISTextHelper.join((Component)sep, stages)}).m_130940_(ChatFormatting.GRAY);
                event.getToolTip().add(desc);
                if (restriction.shouldPreventInventory()) {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.itemstages.debug.drop").m_130940_(ChatFormatting.RED));
                }
                if (restriction.shouldPreventPickup()) {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.itemstages.debug.pickup").m_130940_(ChatFormatting.RED));
                }
                if (restriction.shouldPreventUsing()) {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.itemstages.debug.use").m_130940_(ChatFormatting.RED));
                }
                if (restriction.shouldPreventAttacking()) {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.itemstages.debug.attack").m_130940_(ChatFormatting.RED));
                }
                if (restriction.shouldHideInJEI()) {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.itemstages.debug.jei").m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    private boolean canAffectPlayer(DamageSource source) {
        return source != null && source.m_7639_() instanceof Player && this.canAffectPlayer((Player)source.m_7639_());
    }

    private boolean canAffectPlayer(Player player) {
        return player != null && !player.m_9236_().f_46443_ && !(player instanceof FakePlayer);
    }
}

