/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.music.client;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class MusicToast
implements Toast {
    public static final int TEXT_LEFT_MARGIN = 30;
    public static final int TEXT_RIGHT_MARGIN = 7;
    private final List<FormattedCharSequence> description;
    private final ItemStack icon;

    public MusicToast(Component name, ItemStack icon) {
        this(Minecraft.m_91087_().f_91062_, name, icon);
    }

    public MusicToast(Font font, Component name, ItemStack icon) {
        this.description = font.m_92923_((FormattedText)name, 123);
        this.icon = icon;
    }

    public Toast.Visibility m_7172_(@NotNull GuiGraphics graphics, @NotNull ToastComponent component, long startTime) {
        int height = 20 + Math.max(1, this.getDescription().size()) * 12;
        if (this.m_7828_() == 160 && this.getDescription().size() <= 1) {
            graphics.m_280218_(f_94893_, 0, 0, 0, 0, this.m_7828_(), height);
        } else {
            int m = Math.min(4, height - 28);
            this.renderBackgroundRow(graphics, this.m_7828_(), 0, 0, 28);
            for (int n = 28; n < height - m; n += 10) {
                this.renderBackgroundRow(graphics, this.m_7828_(), 16, n, Math.min(16, height - n - m));
            }
            this.renderBackgroundRow(graphics, this.m_7828_(), 32 - m, height - m, m);
        }
        graphics.m_280614_(component.m_94929_().f_91062_, (Component)Component.m_237115_((String)"sounds.musicmanager.now_playing"), 30, 7, 5046016, false);
        for (int i = 0; i < this.getDescription().size(); ++i) {
            graphics.m_280649_(component.m_94929_().f_91062_, this.getDescription().get(i), 30, 18 + i * 12, -1, false);
        }
        graphics.m_280480_(this.getIcon(), 9, height / 2 - 8);
        return startTime >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    private void renderBackgroundRow(GuiGraphics graphics, int i, int vOffset, int y, int vHeight) {
        int uWidth = vOffset == 0 ? 20 : 5;
        int n = Math.min(60, i - uWidth);
        graphics.m_280218_(f_94893_, 0, y, 0, vOffset, uWidth, vHeight);
        for (int o = uWidth; o < i - n; o += 64) {
            graphics.m_280218_(f_94893_, o, y, 32, vOffset, Math.min(64, i - o - n), vHeight);
        }
        graphics.m_280218_(f_94893_, i - n, y, 160 - n, vOffset, n, vHeight);
    }

    public List<FormattedCharSequence> getDescription() {
        return this.description;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MusicToast that = (MusicToast)obj;
        return Objects.equals(this.description, that.description) && Objects.equals(this.icon, that.icon);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.icon);
    }

    public String toString() {
        return "MusicToast[description=" + this.description + ", stack=" + this.icon + "]";
    }
}

