/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.music.client;

import com.gizmo.music.MusicManager;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;

public class MusicResources {
    private static final Map<ResourceLocation, ResourceLocation> DIMENSION_ICONS = new HashMap<ResourceLocation, ResourceLocation>();
    static final ResourceManagerReloadListener LISTENER = MusicResources::reloadDimensionIcons;

    public static Map<ResourceLocation, ResourceLocation> getDimensionIcons() {
        return Collections.unmodifiableMap(DIMENSION_ICONS);
    }

    private static void reloadDimensionIcons(ResourceManager resourceManager) {
        DIMENSION_ICONS.clear();
        FileToIdConverter converter = FileToIdConverter.m_246568_((String)"musicmanager/dimensions");
        converter.m_247457_(resourceManager).forEach((k, v) -> {
            String[] split = k.m_135815_().split("/");
            if (split.length != 4) {
                MusicManager.LOGGER.error("The path for a music manager dimension resource is incorrect! Expected 'musicmanager/dimensions/<dimension namespace>/<dimension path>.json', found '{}'", (Object)k.m_135815_());
                return;
            }
            ResourceLocation dimension = new ResourceLocation(split[2], split[3].replace(".json", ""));
            try (BufferedReader reader = v.m_215508_();){
                JsonObject json = GsonHelper.m_13859_((Reader)reader);
                String item = json.get("item").getAsString();
                DIMENSION_ICONS.put(dimension, new ResourceLocation(item));
            }
            catch (IOException e) {
                MusicManager.LOGGER.error("Failed to read a music manager dimension resource! Are you missing a property? File: '{}'", (Object)k.m_135815_());
            }
        });
    }
}

