/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.music.client;

import com.gizmo.music.MusicConfig;
import com.gizmo.music.MusicManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;

public class MusicManagerScreen
extends Screen {
    static final ResourceLocation TEXTURE = new ResourceLocation("musicmanager", "textures/gui/manager_screen.png");
    protected int leftPos;
    protected int topPos;
    private CheckBox displayRecordToast;
    private CheckBox playToastSound;
    private EditBox minDelay;
    private EditBox maxDelay;
    private MusicConfig newConfig;

    public MusicManagerScreen() {
        super((Component)Component.m_237115_((String)"gui.musicmanager.music_manager"));
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 142) / 2;
        this.topPos = (this.f_96544_ - 86) / 2;
        this.displayRecordToast = new CheckBox(this.leftPos + 43, this.topPos + 23, (Component)Component.m_237115_((String)"gui.musicmanager.display_record_toast"), MusicManager.displayRecordToast);
        this.m_142416_((GuiEventListener)this.displayRecordToast);
        this.playToastSound = new CheckBox(this.leftPos + 100, this.topPos + 23, (Component)Component.m_237115_((String)"gui.musicmanager.play_toast_sound"), !MusicManager.silentMusicToasts);
        this.m_142416_((GuiEventListener)this.playToastSound);
        this.minDelay = new EditBox(this.f_96547_, this.leftPos + 26, this.topPos + 53, 26, 12, (Component)Component.m_237115_((String)"gui.musicmanager.min_song_delay"));
        this.minDelay.m_94199_(10);
        this.minDelay.m_94153_(s -> StringUtils.isNumeric((CharSequence)s) || s.isEmpty());
        this.minDelay.m_94182_(false);
        this.minDelay.m_94202_(0xFFFFFF);
        this.minDelay.m_93692_(false);
        this.minDelay.m_94144_(String.valueOf(MusicManager.minSongDelay));
        this.m_142416_((GuiEventListener)this.minDelay);
        this.maxDelay = new EditBox(this.f_96547_, this.leftPos + 86, this.topPos + 53, 32, 12, (Component)Component.m_237115_((String)"gui.musicmanager.max_song_delay"));
        this.maxDelay.m_94199_(10);
        this.maxDelay.m_94153_(s -> StringUtils.isNumeric((CharSequence)s) || s.isEmpty());
        this.maxDelay.m_94182_(false);
        this.maxDelay.m_94202_(0xFFFFFF);
        this.maxDelay.m_93692_(false);
        this.maxDelay.m_94144_(String.valueOf(MusicManager.maxSongDelay));
        this.m_142416_((GuiEventListener)this.maxDelay);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.musicmanager.save"), button -> this.m_7379_()).m_252987_(this.leftPos + 14, this.topPos + 69, 54, 12).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.musicmanager.exit"), button -> Minecraft.m_91087_().popGuiLayer()).m_252987_(this.leftPos + 74, this.topPos + 69, 54, 12).m_253136_());
    }

    public void m_86600_() {
        super.m_86600_();
        this.minDelay.m_94120_();
        this.maxDelay.m_94120_();
    }

    public void m_88315_(GuiGraphics graphics, int x, int y, float partialTicks) {
        graphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, 142, 86);
        super.m_88315_(graphics, x, y, partialTicks);
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.leftPos + 50 - this.f_96539_.getString().length(), this.topPos + 6, 0x404040, false);
        this.renderHoverTooltips(graphics, x, y);
        graphics.m_280480_(new ItemStack((ItemLike)Items.f_42701_), this.leftPos + 26, this.topPos + 22);
    }

    private void renderHoverTooltips(GuiGraphics graphics, int x, int y) {
        if (this.isHovering(44, 24, 12, 12, x, y)) {
            graphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.musicmanager.display_record_toast.desc"), 200), x, y);
        } else if (this.isHovering(101, 24, 12, 12, x, y)) {
            graphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.musicmanager.play_toast_sound.desc"), 175), x, y);
        } else if (this.isHovering(25, 51, 32, 12, x, y) && !this.minDelay.m_93696_()) {
            graphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.musicmanager.min_song_delay.desc"), 200), x, y);
        } else if (this.isHovering(85, 51, 32, 12, x, y) && !this.maxDelay.m_93696_()) {
            graphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"gui.musicmanager.max_song_delay.desc"), 175), x, y);
        }
    }

    protected boolean isHovering(int startX, int startY, int xSize, int ySize, double x, double y) {
        int i = this.leftPos;
        int j = this.topPos;
        return (x -= (double)i) >= (double)(startX - 1) && x < (double)(startX + xSize + 1) && (y -= (double)j) >= (double)(startY - 1) && y < (double)(startY + ySize + 1);
    }

    public void m_7379_() {
        MusicManager.CLIENT.displayRecordToast.set((Object)this.displayRecordToast.selected);
        MusicManager.CLIENT.silentMusicToasts.set((Object)(!this.playToastSound.selected ? 1 : 0));
        MusicManager.CLIENT.minSongDelay.set((Object)Integer.valueOf(this.minDelay.m_94155_()));
        MusicManager.CLIENT.maxSongDelay.set((Object)Integer.valueOf(this.maxDelay.m_94155_()));
        MusicManager.rebakeOptions();
        super.m_7379_();
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            Minecraft.m_91087_().popGuiLayer();
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    public static class CheckBox
    extends AbstractButton {
        private boolean selected;

        public CheckBox(int x, int y, Component message, boolean selected) {
            super(x, y, 12, 12, message);
            this.selected = selected;
        }

        public void m_5691_() {
            this.selected = !this.selected;
        }

        protected void m_168797_(NarrationElementOutput output) {
            output.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
            if (this.f_93623_) {
                if (this.m_93696_()) {
                    output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.focused"));
                } else {
                    output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.hovered"));
                }
            }
        }

        public void m_87963_(GuiGraphics graphics, int x, int y, float partialTicks) {
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.enableBlend();
            graphics.m_280218_(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_274382_() ? 14 : 0, this.selected ? 100 : 86, 14, 14);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

