/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.music;

import com.gizmo.music.client.MusicResources;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ToastUtil {
    private static final Map<ResourceLocation, RecordItem> CACHED_RECORDS = new TreeMap<ResourceLocation, RecordItem>();

    @Nullable
    public static Component getSoundName(SoundInstance instance) {
        String soundLocation = instance.m_5891_().m_119787_().toString().replace('/', '.').replace(':', '.');
        if (I18n.m_118936_((String)("sounds.musicmanager." + soundLocation))) {
            return Component.m_237115_((String)("sounds.musicmanager." + soundLocation));
        }
        return null;
    }

    @Nullable
    public static RecordItem getDiscFromSound(SoundInstance instance) {
        if (CACHED_RECORDS.isEmpty()) {
            for (RecordItem item2 : ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof RecordItem).map(RecordItem.class::cast).toList()) {
                CACHED_RECORDS.put(item2.m_43051_().m_11660_(), item2);
            }
        }
        if (CACHED_RECORDS.containsKey(instance.m_7904_())) {
            return CACHED_RECORDS.get(instance.m_7904_());
        }
        return null;
    }

    public static ItemStack getItemByDimension(Level level) {
        ResourceLocation item;
        Optional disc;
        ItemStack defaultItem = new ItemStack((ItemLike)Items.f_42701_);
        if (ForgeRegistries.ITEMS.tags() != null && !Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(ItemTags.f_13158_).isEmpty() && (disc = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(ItemTags.f_13158_).getRandomElement(level.m_213780_())).isPresent()) {
            defaultItem = new ItemStack((ItemLike)disc.get());
        }
        return (item = MusicResources.getDimensionIcons().get(level.m_46472_().m_135782_())) != null ? new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(item)) : defaultItem;
    }
}

