/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.music;

import com.gizmo.music.MusicConfig;
import com.mojang.logging.LogUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod(value="musicmanager")
public class MusicManager {
    public static final String MODID = "musicmanager";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static ForgeConfigSpec CLIENT_SPEC;
    public static MusicConfig CLIENT;
    public static boolean displayRecordToast;
    public static boolean silentMusicToasts;
    public static int minSongDelay;
    public static int maxSongDelay;

    public MusicManager() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(MusicConfig::new);
        CLIENT = (MusicConfig)specPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::reloadConfig);
    }

    public void reloadConfig(ModConfigEvent event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            MusicManager.rebakeOptions();
            LOGGER.debug("Reloading Music Manager Config!");
        }
    }

    public static void rebakeOptions() {
        displayRecordToast = (Boolean)MusicManager.CLIENT.displayRecordToast.get();
        silentMusicToasts = (Boolean)MusicManager.CLIENT.silentMusicToasts.get();
        minSongDelay = (Integer)MusicManager.CLIENT.minSongDelay.get();
        maxSongDelay = (Integer)MusicManager.CLIENT.maxSongDelay.get();
    }

    static {
        displayRecordToast = true;
        silentMusicToasts = true;
        minSongDelay = 10;
        maxSongDelay = 30;
    }
}

