/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.inventory.BinMekanismInventory;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.recipe.upgrade.EnergyRecipeData;
import mekanism.common.recipe.upgrade.FluidRecipeData;
import mekanism.common.recipe.upgrade.ItemRecipeData;
import mekanism.common.recipe.upgrade.LockRecipeData;
import mekanism.common.recipe.upgrade.QIORecipeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeType;
import mekanism.common.recipe.upgrade.SecurityRecipeData;
import mekanism.common.recipe.upgrade.SortingRecipeData;
import mekanism.common.recipe.upgrade.UpgradesRecipeData;
import mekanism.common.recipe.upgrade.chemical.GasRecipeData;
import mekanism.common.recipe.upgrade.chemical.InfusionRecipeData;
import mekanism.common.recipe.upgrade.chemical.PigmentRecipeData;
import mekanism.common.recipe.upgrade.chemical.SlurryRecipeData;
import mekanism.common.tier.BinTier;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public interface RecipeUpgradeData<TYPE extends RecipeUpgradeData<TYPE>> {
    @Nullable
    public TYPE merge(TYPE var1);

    public boolean applyToStack(ItemStack var1);

    @NotNull
    public static Set<RecipeUpgradeType> getSupportedTypes(ItemStack stack) {
        ItemBlockBin bin;
        if (stack.m_41619_()) {
            return Collections.emptySet();
        }
        EnumSet<RecipeUpgradeType> supportedTypes = EnumSet.noneOf(RecipeUpgradeType.class);
        Item item = stack.m_41720_();
        TileEntityMekanism tile = null;
        if (item instanceof BlockItem) {
            IHasTileEntity hasTileEntity;
            Object tileEntity;
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            if (block instanceof IHasTileEntity && (tileEntity = (hasTileEntity = (IHasTileEntity)block).createDummyBlockEntity()) instanceof TileEntityMekanism) {
                tile = (TileEntityMekanism)tileEntity;
            }
            if (Attribute.has(block, AttributeUpgradeSupport.class)) {
                supportedTypes.add(RecipeUpgradeType.UPGRADE);
            }
        }
        if (stack.getCapability(Capabilities.STRICT_ENERGY).isPresent() || tile != null && tile.handles(SubstanceType.ENERGY)) {
            supportedTypes.add(RecipeUpgradeType.ENERGY);
        }
        if (FluidUtil.getFluidHandler((ItemStack)stack).isPresent() || tile != null && tile.handles(SubstanceType.FLUID)) {
            supportedTypes.add(RecipeUpgradeType.FLUID);
        }
        if (stack.getCapability(Capabilities.GAS_HANDLER).isPresent() || tile != null && tile.handles(SubstanceType.GAS)) {
            supportedTypes.add(RecipeUpgradeType.GAS);
        }
        if (stack.getCapability(Capabilities.INFUSION_HANDLER).isPresent() || tile != null && tile.handles(SubstanceType.INFUSION)) {
            supportedTypes.add(RecipeUpgradeType.INFUSION);
        }
        if (stack.getCapability(Capabilities.PIGMENT_HANDLER).isPresent() || tile != null && tile.handles(SubstanceType.PIGMENT)) {
            supportedTypes.add(RecipeUpgradeType.PIGMENT);
        }
        if (stack.getCapability(Capabilities.SLURRY_HANDLER).isPresent() || tile != null && tile.handles(SubstanceType.SLURRY)) {
            supportedTypes.add(RecipeUpgradeType.SLURRY);
        }
        if (item instanceof IItemSustainedInventory || tile != null && tile.persistInventory()) {
            supportedTypes.add(RecipeUpgradeType.ITEM);
        }
        if (stack.getCapability(Capabilities.OWNER_OBJECT).isPresent() || tile != null && tile.hasSecurity()) {
            supportedTypes.add(RecipeUpgradeType.SECURITY);
        }
        if (item instanceof ItemBlockBin && (bin = (ItemBlockBin)item).getTier() != BinTier.CREATIVE) {
            supportedTypes.add(RecipeUpgradeType.LOCK);
        }
        if (tile instanceof TileEntityFactory) {
            supportedTypes.add(RecipeUpgradeType.SORTING);
        }
        if (item instanceof IQIODriveItem) {
            supportedTypes.add(RecipeUpgradeType.QIO_DRIVE);
        }
        return supportedTypes;
    }

    @Nullable
    private static <TYPE extends RecipeUpgradeData<TYPE>> TYPE getContainerUpgradeData(@NotNull ItemStack stack, String key, Function<ListTag, TYPE> creator) {
        ListTag containers = ItemDataUtils.getList(stack, key);
        return (TYPE)(containers.isEmpty() ? null : (RecipeUpgradeData)creator.apply(containers));
    }

    @Nullable
    public static RecipeUpgradeData<?> getUpgradeData(@NotNull RecipeUpgradeType type, @NotNull ItemStack stack) {
        Item item = stack.m_41720_();
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RecipeUpgradeType.ENERGY -> RecipeUpgradeData.getContainerUpgradeData(stack, "EnergyContainers", EnergyRecipeData::new);
            case RecipeUpgradeType.FLUID -> RecipeUpgradeData.getContainerUpgradeData(stack, "FluidTanks", FluidRecipeData::new);
            case RecipeUpgradeType.GAS -> RecipeUpgradeData.getContainerUpgradeData(stack, "GasTanks", GasRecipeData::new);
            case RecipeUpgradeType.INFUSION -> RecipeUpgradeData.getContainerUpgradeData(stack, "InfusionTanks", InfusionRecipeData::new);
            case RecipeUpgradeType.PIGMENT -> RecipeUpgradeData.getContainerUpgradeData(stack, "PigmentTanks", PigmentRecipeData::new);
            case RecipeUpgradeType.SLURRY -> RecipeUpgradeData.getContainerUpgradeData(stack, "SlurryTanks", SlurryRecipeData::new);
            case RecipeUpgradeType.ITEM -> {
                ListTag inventory = ((IItemSustainedInventory)item).getSustainedInventory(stack);
                if (inventory == null || inventory.isEmpty()) {
                    yield null;
                }
                yield new ItemRecipeData(inventory);
            }
            case RecipeUpgradeType.LOCK -> {
                BinMekanismInventory inventory = BinMekanismInventory.create(stack);
                if (inventory == null || !inventory.getBinSlot().isLocked()) {
                    yield null;
                }
                yield new LockRecipeData(inventory);
            }
            case RecipeUpgradeType.SECURITY -> {
                UUID ownerUUID = ISecurityUtils.INSTANCE.getOwnerUUID((ICapabilityProvider)stack);
                if (ownerUUID == null) {
                    yield null;
                }
                SecurityMode securityMode = stack.getCapability(Capabilities.SECURITY_OBJECT).map(ISecurityObject::getSecurityMode).orElse(SecurityMode.PUBLIC);
                yield new SecurityRecipeData(ownerUUID, securityMode);
            }
            case RecipeUpgradeType.SORTING -> {
                boolean sorting = ItemDataUtils.getBoolean(stack, "sorting");
                if (sorting) {
                    yield SortingRecipeData.SORTING;
                }
                yield null;
            }
            case RecipeUpgradeType.UPGRADE -> UpgradesRecipeData.tryCreate(ItemDataUtils.getCompound(stack, "componentUpgrade"));
            case RecipeUpgradeType.QIO_DRIVE -> {
                long[] storedItems;
                IQIODriveItem.DriveMetadata data = IQIODriveItem.DriveMetadata.load(stack);
                if (data.count() > 0L && ((IQIODriveItem)item).hasStoredItemMap(stack) && (storedItems = ItemDataUtils.getLongArray(stack, "qioItemMap")).length % 3 == 0) {
                    yield new QIORecipeData(data, storedItems);
                }
                yield null;
            }
        };
    }

    @Nullable
    public static <TYPE extends RecipeUpgradeData<TYPE>> TYPE mergeUpgradeData(List<RecipeUpgradeData<?>> upgradeData) {
        if (upgradeData.isEmpty()) {
            return null;
        }
        RecipeUpgradeData<?> data = upgradeData.get(0);
        for (int i = 1; i < upgradeData.size(); ++i) {
            if ((data = data.merge(upgradeData.get(i))) != null) continue;
            return null;
        }
        return (TYPE)data;
    }

    @Nullable
    default public TileEntityMekanism getTileFromBlock(Block block) {
        IHasTileEntity hasTileEntity;
        Object tileEntity;
        if (block instanceof IHasTileEntity && (tileEntity = (hasTileEntity = (IHasTileEntity)block).createDummyBlockEntity()) instanceof TileEntityMekanism) {
            return (TileEntityMekanism)tileEntity;
        }
        return null;
    }
}

